/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HashList<T>
extends LinkedHashSet<T> {
    @NotNull
    protected List<T> list;

    public HashList() {
        this.list = new ArrayList<T>();
    }

    public HashList(Collection<? extends T> toCopy) {
        this();
        this.addAll(toCopy);
    }

    public HashList(int initialCapacity) {
        super(initialCapacity);
        this.list = new ArrayList<T>(initialCapacity);
    }

    public T set(int i, T value) {
        T oldElement = this.list.get(i);
        this.list.set(i, value);
        super.remove(oldElement);
        super.add(value);
        return oldElement;
    }

    @Override
    public boolean add(T value) {
        boolean result = super.add(value);
        if (result) {
            this.list.add(value);
        }
        return result;
    }

    public void add(int i, T value) {
        boolean result = super.add(value);
        if (result) {
            this.list.add(i, value);
        }
    }

    @Override
    public void clear() {
        this.list.clear();
        super.clear();
    }

    public T get(int i) {
        return this.list.get(i);
    }

    @Nullable
    public T getOrNull(int index) {
        return index >= 0 && index < this.size() ? (T)this.get(index) : null;
    }

    public List<T> elements() {
        return this.list;
    }

    @Override
    public Object clone() {
        HashList dup = (HashList)super.clone();
        dup.list = new ArrayList<T>(this.list);
        return dup;
    }

    @Override
    public Object @NotNull [] toArray() {
        return this.list.toArray();
    }

    @Override
    public String toString() {
        return this.list.toString();
    }

    public boolean replace(T existing, @Nullable T replacement) {
        if (existing.equals(replacement)) {
            return false;
        }
        int index = this.indexOf(existing);
        if (index != -1) {
            if (replacement == null || this.contains(replacement)) {
                this.remove(index);
            } else {
                this.set(index, replacement);
            }
            return true;
        }
        return false;
    }

    public T remove(int i) {
        T o = this.list.remove(i);
        super.remove(o);
        return o;
    }

    @Override
    public boolean remove(Object o) {
        this.list.remove(o);
        return super.remove(o);
    }

    public int indexOf(T obj) {
        return this.contains(obj) ? this.list.indexOf(obj) : -1;
    }

    public void swap(int source, int target, BiConsumer<T, T> postSwap) {
        if (source == target || source < 0 || target < 0) {
            return;
        }
        int size = this.size();
        if (source >= size || target >= size) {
            return;
        }
        T sourceT = this.list.get(source);
        T targetT = this.list.get(target);
        this.list.set(source, targetT);
        this.list.set(target, sourceT);
        postSwap.accept(sourceT, targetT);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HashList)) {
            return o instanceof List && this.list.equals(o);
        }
        return this.list.equals(((HashList)o).list);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public int size() {
        return this.list.size();
    }
}

