/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync.list;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.common.inventory.container.sync.list.SyncableList;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class SyncableFrequencyList<FREQUENCY extends Frequency>
extends SyncableList<FREQUENCY> {
    private final FrequencyType<FREQUENCY> type;

    public static <FREQUENCY extends Frequency> SyncableFrequencyList<FREQUENCY> create(FrequencyType<FREQUENCY> type, Supplier<? extends @NotNull Collection<FREQUENCY>> getter, Consumer<@NotNull List<FREQUENCY>> setter) {
        return new SyncableFrequencyList<FREQUENCY>(type, getter, setter);
    }

    private SyncableFrequencyList(FrequencyType<FREQUENCY> type, Supplier<? extends @NotNull Collection<FREQUENCY>> getter, Consumer<@NotNull List<FREQUENCY>> setter) {
        super(getter, setter);
        this.type = type;
    }

    @Override
    protected int getValueHashCode() {
        int hashCode = 1;
        for (Frequency frequency : this.getRaw()) {
            hashCode = 31 * hashCode + frequency.hashCode();
        }
        return hashCode;
    }

    @Override
    protected List<FREQUENCY> deserializeList(RegistryFriendlyByteBuf buffer) {
        return buffer.readList(buf -> this.type.create(buffer));
    }

    @Override
    protected void serializeListElement(RegistryFriendlyByteBuf buffer, FREQUENCY frequency) {
        this.type.streamCodec().encode((Object)buffer, frequency);
    }
}

