/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync.dynamic;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.annotation.ElementType;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.MekAnnotationScanner;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.network.to_client.container.property.PropertyType;
import mekanism.common.util.LambdaMetaFactoryUtil;
import net.minecraft.core.BlockPos;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class SyncMapper
extends MekAnnotationScanner.BaseAnnotationScanner {
    public static final SyncMapper INSTANCE = new SyncMapper();
    public static final String DEFAULT_TAG = "default";
    private final List<SpecialPropertyHandler<?>> specialProperties = new ArrayList();
    private final Map<Class<?>, PropertyDataClassCache> syncablePropertyMap = new Object2ObjectOpenHashMap();

    private SyncMapper() {
        this.specialProperties.add(new SpecialPropertyHandler<IExtendedFluidTank>(IExtendedFluidTank.class, SpecialPropertyData.create(FluidStack.class, IFluidTank::getFluid, IExtendedFluidTank::setStackUnchecked)));
        this.specialProperties.add(new SpecialPropertyHandler<IChemicalTank>(IChemicalTank.class, SpecialPropertyData.create(ChemicalStack.class, IChemicalTank::getStack, IChemicalTank::setStackUnchecked)));
        this.specialProperties.add(new SpecialPropertyHandler<IEnergyContainer>(IEnergyContainer.class, SpecialPropertyData.create(Long.TYPE, IEnergyContainer::getEnergy, IEnergyContainer::setEnergy)));
        this.specialProperties.add(new SpecialPropertyHandler<BasicHeatCapacitor>(BasicHeatCapacitor.class, SpecialPropertyData.create(Double.TYPE, BasicHeatCapacitor::getHeatCapacity, BasicHeatCapacitor::setHeatCapacityFromPacket), SpecialPropertyData.create(Double.TYPE, IHeatCapacitor::getHeat, IHeatCapacitor::setHeat)));
        this.specialProperties.add(new SpecialPropertyHandler<MergedTank>(MergedTank.class, SpecialPropertyData.create(FluidStack.class, obj -> obj.getFluidTank().getFluid(), (obj, val) -> obj.getFluidTank().setStackUnchecked((FluidStack)val)), SpecialPropertyData.create(ChemicalStack.class, obj -> obj.getChemicalTank().getStack(), (obj, val) -> obj.getChemicalTank().setStackUnchecked((ChemicalStack)val))));
        this.specialProperties.add(new SpecialPropertyHandler<VoxelCuboid>(VoxelCuboid.class, SpecialPropertyData.create(BlockPos.class, VoxelCuboid::getMinPos, VoxelCuboid::setMinPos), SpecialPropertyData.create(BlockPos.class, VoxelCuboid::getMaxPos, VoxelCuboid::setMaxPos)));
    }

    @Override
    protected Map<ElementType, Type[]> getSupportedTypes() {
        return Collections.singletonMap(ElementType.FIELD, new Type[]{Type.getType(ContainerSync.class)});
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void collectScanData(Map<String, Class<?>> classNameCache, Map<Class<?>, List<ModFileScanData.AnnotationData>> knownClasses, Set<IModFileInfo> modFileData) {
        rawPropertyMap = new Object2ObjectOpenHashMap();
        fallbackTagsList = Collections.singletonList("default");
        for (Map.Entry<Class<?>, List<ModFileScanData.AnnotationData>> entry : knownClasses.entrySet()) {
            annotatedClass = entry.getKey();
            propertyInfo = new ArrayList<PropertyFieldInfo>();
            rawPropertyMap.put(annotatedClass, propertyInfo);
            for (ModFileScanData.AnnotationData data : entry.getValue()) {
                block12: {
                    fieldName = data.memberName();
                    field = SyncMapper.getField(annotatedClass, fieldName);
                    if (field == null) continue;
                    getterName = SyncMapper.getAnnotationValue(data, "getter", "");
                    fieldType = field.getType();
                    handler = null;
                    for (SpecialPropertyHandler<?> h : this.specialProperties) {
                        if (!h.fieldType.isAssignableFrom(fieldType)) continue;
                        handler = h;
                        break;
                    }
                    try {
                        if (handler != null) ** GOTO lbl39
                        type = PropertyType.getFromType(fieldType);
                        setterName = SyncMapper.getAnnotationValue(data, "setter", "");
                        if (type != null) {
                            newField = new PropertyField(new TrackedFieldData[]{new TrackedFieldData(LambdaMetaFactoryUtil.createGetter(field, annotatedClass, getterName), LambdaMetaFactoryUtil.createSetter(field, annotatedClass, setterName), type)});
                            break block12;
                        }
                        if (fieldType.isEnum()) {
                            newField = new PropertyField(new TrackedFieldData[]{new EnumFieldData(LambdaMetaFactoryUtil.createGetter(field, annotatedClass, getterName), LambdaMetaFactoryUtil.createSetter(field, annotatedClass, setterName), fieldType)});
                            break block12;
                        }
                        if (!fieldType.isArray()) ** GOTO lbl37
                        arrayFieldType = fieldType.getComponentType();
                        arrayType = PropertyType.getFromType(arrayFieldType);
                        if (arrayType != null) {
                            newField = new PropertyField(new TrackedFieldData[]{new ArrayFieldData(LambdaMetaFactoryUtil.createGetter(field, annotatedClass, getterName), arrayType)});
                        } else {
                            Mekanism.logger.error("Attempted to sync an invalid array field '{}' in class '{}'.", (Object)fieldName, (Object)annotatedClass.getSimpleName());
                            continue;
lbl37:
                            // 1 sources

                            Mekanism.logger.error("Attempted to sync an invalid field '{}' in class '{}'.", (Object)fieldName, (Object)annotatedClass.getSimpleName());
                            continue;
lbl39:
                            // 1 sources

                            newField = SyncMapper.createSpecialProperty(handler, field, annotatedClass, getterName);
                        }
                    }
                    catch (Throwable throwable) {
                        Mekanism.logger.error("Failed to create sync data for field '{}' in class '{}'.", new Object[]{fieldName, annotatedClass.getSimpleName(), throwable});
                        continue;
                    }
                }
                fullPath = annotatedClass.getName() + "#" + fieldName;
                for (String tag : SyncMapper.getAnnotationValue(data, "tags", fallbackTagsList)) {
                    propertyInfo.add(new PropertyFieldInfo(fullPath, tag, newField));
                }
            }
        }
        propertyMap = SyncMapper.combineWithParents(rawPropertyMap);
        for (MekAnnotationScanner.BaseAnnotationScanner.ClassBasedInfo<INFO> classPropertyInfo : propertyMap) {
            cache = new PropertyDataClassCache();
            classPropertyInfo.infoList().sort(Comparator.comparing((Function<PropertyFieldInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$collectScanData$4(mekanism.common.inventory.container.sync.dynamic.SyncMapper$PropertyFieldInfo ), (Lmekanism/common/inventory/container/sync/dynamic/SyncMapper$PropertyFieldInfo;)Ljava/lang/String;)()));
            for (PropertyFieldInfo field : classPropertyInfo.infoList()) {
                cache.propertyFieldMap.put((Object)field.tag, (Object)field.field);
            }
            this.syncablePropertyMap.put(classPropertyInfo.clazz(), cache);
        }
    }

    public void setup(MekanismContainer container, Class<?> holderClass, Supplier<Object> holderSupplier) {
        this.setup(container, holderClass, holderSupplier, DEFAULT_TAG);
    }

    public void setup(MekanismContainer container, Class<?> holderClass, Supplier<Object> holderSupplier, String tag) {
        PropertyDataClassCache cache = this.syncablePropertyMap.get(holderClass);
        if (cache == null) {
            cache = SyncMapper.getData(this.syncablePropertyMap, holderClass, PropertyDataClassCache.EMPTY);
            this.syncablePropertyMap.put(holderClass, cache);
        }
        for (PropertyField field : cache.propertyFieldMap.get((Object)tag)) {
            for (TrackedFieldData data : field.trackedData) {
                data.track(container, holderSupplier);
            }
        }
    }

    private static <O> PropertyField createSpecialProperty(SpecialPropertyHandler<O> handler, Field field, Class<?> objType, String getterName) throws Throwable {
        PropertyField ret = new PropertyField(new TrackedFieldData[0]);
        Function fieldGetter = LambdaMetaFactoryUtil.createGetter(field, objType, getterName);
        for (SpecialPropertyData data : handler.specialData) {
            TrackedFieldData trackedField = TrackedFieldData.create(data.propertyType, obj -> data.get(fieldGetter.apply(obj)), (obj, val) -> data.set(fieldGetter.apply(obj), val));
            if (trackedField == null) continue;
            ret.addTrackedData(trackedField);
        }
        return ret;
    }

    private static /* synthetic */ String lambda$collectScanData$4(PropertyFieldInfo info) {
        return info.fieldPath() + "|" + info.tag();
    }

    private static class SpecialPropertyHandler<O> {
        private final Class<O> fieldType;
        private final List<SpecialPropertyData<O>> specialData;

        @SafeVarargs
        private SpecialPropertyHandler(Class<O> fieldType, SpecialPropertyData<O> ... data) {
            this.fieldType = fieldType;
            this.specialData = List.of(data);
        }
    }

    protected static class SpecialPropertyData<O> {
        private final Class<?> propertyType;
        private final Function<O, ?> getter;
        private final BiConsumer<O, Object> setter;

        private SpecialPropertyData(Class<?> propertyType, Function<O, ?> getter, BiConsumer<O, Object> setter) {
            this.propertyType = propertyType;
            this.getter = getter;
            this.setter = setter;
        }

        protected Object get(O obj) {
            return this.getter.apply(obj);
        }

        protected void set(O obj, Object val) {
            this.setter.accept(obj, val);
        }

        protected static <O, V> SpecialPropertyData<O> create(Class<V> propertyType, Function<O, V> getter, BiConsumer<O, V> setter) {
            return new SpecialPropertyData<O>(propertyType, getter, setter);
        }
    }

    private static class PropertyField {
        private final List<TrackedFieldData> trackedData = new ArrayList<TrackedFieldData>();

        private PropertyField(TrackedFieldData ... data) {
            Collections.addAll(this.trackedData, data);
        }

        private void addTrackedData(TrackedFieldData data) {
            this.trackedData.add(data);
        }
    }

    protected static class TrackedFieldData {
        private PropertyType propertyType;
        private final Function<Object, Object> getter;
        private final BiConsumer<Object, Object> setter;

        protected TrackedFieldData(Function<Object, Object> getter, BiConsumer<Object, Object> setter) {
            this.getter = getter;
            this.setter = setter;
        }

        private TrackedFieldData(Function<Object, Object> getter, BiConsumer<Object, Object> setter, PropertyType propertyType) {
            this(getter, setter);
            this.propertyType = propertyType;
        }

        protected void track(MekanismContainer container, Supplier<Object> holderSupplier) {
            container.track(this.createSyncableData(holderSupplier));
        }

        protected Object get(Object dataObj) {
            return this.getter.apply(dataObj);
        }

        protected void set(Object dataObj, Object value) {
            this.setter.accept(dataObj, value);
        }

        protected ISyncableData createSyncableData(Supplier<Object> obj) {
            return this.create(() -> {
                Object dataObj = obj.get();
                return dataObj == null ? this.getDefault() : this.get(dataObj);
            }, val -> {
                Object dataObj = obj.get();
                if (dataObj != null) {
                    this.set(dataObj, val);
                }
            });
        }

        protected ISyncableData create(Supplier<Object> getter, Consumer<Object> setter) {
            return this.propertyType.create(getter, setter);
        }

        protected Object getDefault() {
            return this.propertyType.getDefault();
        }

        protected static TrackedFieldData create(Class<?> propertyType, Function<Object, Object> getter, BiConsumer<Object, Object> setter) {
            if (propertyType.isEnum()) {
                return new EnumFieldData(getter, setter, propertyType);
            }
            if (propertyType.isArray()) {
                Class<?> arrayType = propertyType.getComponentType();
                PropertyType type = PropertyType.getFromType(arrayType);
                if (type == null) {
                    Mekanism.logger.error("Tried to create property data for invalid array type '{}'.", (Object)arrayType.getName());
                    return null;
                }
                return new ArrayFieldData(getter, type);
            }
            PropertyType type = PropertyType.getFromType(propertyType);
            if (type == null) {
                Mekanism.logger.error("Tried to create property data for invalid type '{}'.", (Object)propertyType.getName());
                return null;
            }
            return new TrackedFieldData(getter, setter, type);
        }
    }

    protected static class EnumFieldData
    extends TrackedFieldData {
        private final Object[] constants;

        private EnumFieldData(Function<Object, Object> getter, BiConsumer<Object, Object> setter, Class<?> enumClass) {
            super(getter, setter);
            this.constants = enumClass.getEnumConstants();
        }

        @Override
        protected ISyncableData create(Supplier<Object> getter, Consumer<Object> setter) {
            return this.createData((Enum[])this.constants, getter, setter);
        }

        protected <ENUM extends Enum<ENUM>> ISyncableData createData(ENUM[] constants, Supplier<Object> getter, Consumer<Object> setter) {
            return SyncableEnum.create(val -> constants[val], constants[0], () -> (Enum)getter.get(), setter::accept);
        }

        @Override
        protected Object getDefault() {
            return this.constants[0];
        }
    }

    protected static class ArrayFieldData
    extends TrackedFieldData {
        protected ArrayFieldData(Function<Object, Object> getter, PropertyType propertyType) {
            super(getter, null, propertyType);
        }

        @Override
        protected void track(MekanismContainer container, Supplier<Object> holderSupplier) {
            Object holder = holderSupplier.get();
            if (holder != null) {
                Object field = this.get(holder);
                if (field.getClass().isArray()) {
                    int length = Array.getLength(field);
                    int i = 0;
                    while (i < length) {
                        int index = i++;
                        container.track(this.create(() -> {
                            Object obj = holderSupplier.get();
                            return obj == null ? this.getDefault() : Array.get(this.get(obj), index);
                        }, value -> {
                            Object obj = holderSupplier.get();
                            if (obj != null) {
                                Array.set(this.get(obj), index, value);
                            }
                        }));
                    }
                } else {
                    Mekanism.logger.error("Unexpected field type '{}' is not an array.", field.getClass());
                }
            } else {
                Mekanism.logger.error("Unable to get holder object to add array tracker to.");
            }
        }

        @Override
        protected void set(Object dataObj, Object value) {
            throw new UnsupportedOperationException("Unsupported, uses overridden.");
        }

        @Override
        protected ISyncableData createSyncableData(Supplier<Object> obj) {
            throw new UnsupportedOperationException("Unsupported, uses overridden.");
        }
    }

    private record PropertyFieldInfo(String fieldPath, String tag, PropertyField field) {
    }

    private static class PropertyDataClassCache {
        private static final PropertyDataClassCache EMPTY = new PropertyDataClassCache();
        private final Multimap<String, PropertyField> propertyFieldMap = LinkedHashMultimap.create();

        private PropertyDataClassCache() {
        }
    }
}

