/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer.computercraft;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.lua.ILuaAPIFactory;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralCapability;
import java.util.function.BooleanSupplier;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.integration.computer.ComputerEnergyHelper;
import mekanism.common.integration.computer.ComputerFilterHelper;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.computercraft.CCApiObject;
import mekanism.common.integration.computer.computercraft.MekanismPeripheral;
import mekanism.common.registration.impl.TileEntityTypeDeferredRegister;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.base.CapabilityTileEntity;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.Nullable;

public class CCCapabilityHelper {
    private static final ICapabilityProvider<?, @Nullable Direction, IPeripheral> PROVIDER = CCCapabilityHelper.getProvider();

    private static <TILE extends CapabilityTileEntity> ICapabilityProvider<TILE, @Nullable Direction, IPeripheral> getProvider() {
        return CapabilityTileEntity.capabilityProvider(PeripheralCapability.get(), (tile, cap) -> {
            if (((IComputerTile)((Object)tile)).isComputerCapabilityPersistent()) {
                return BasicCapabilityResolver.persistent(cap, () -> MekanismPeripheral.create(tile));
            }
            return BasicCapabilityResolver.create(cap, () -> MekanismPeripheral.create(tile));
        });
    }

    public static <TILE extends CapabilityTileEntity> void addCapability(TileEntityTypeDeferredRegister.BlockEntityTypeBuilder<TILE> builder, BooleanSupplier supportsComputer) {
        builder.with(PeripheralCapability.get(), PROVIDER, supportsComputer);
    }

    public static void addBoundingComputerCapabilities(RegisterCapabilitiesEvent event) {
        TileEntityBoundingBlock.proxyCapability(event, PeripheralCapability.get());
    }

    public static void registerApis() {
        ComputerCraftAPI.registerAPIFactory((ILuaAPIFactory)CCApiObject.create(ComputerEnergyHelper.class, "mekanismEnergyHelper"));
        ComputerCraftAPI.registerAPIFactory((ILuaAPIFactory)CCApiObject.create(ComputerFilterHelper.class, "mekanismFilterHelper"));
    }
}

