/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekatool;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.config.ModuleBooleanConfig;
import mekanism.api.gear.config.ModuleConfig;
import mekanism.api.radial.IRadialDataHelper;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.BasicRadialMode;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.radial.mode.NestedRadialMode;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemAtomicDisassembler;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.PacketLightningRender;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNotNullByDefault
public record ModuleVeinMiningUnit(boolean extended, ExcavationRange excavationRange) implements ICustomModule<ModuleVeinMiningUnit>
{
    public static final ResourceLocation EXTENDED_MODE = Mekanism.rl("extended_mode");
    public static final ResourceLocation EXCAVATION_RANGE = Mekanism.rl("mining_range");
    private static final IRadialDataHelper.BooleanRadialModes RADIAL_MODES = new IRadialDataHelper.BooleanRadialModes(new BasicRadialMode(MekanismLang.RADIAL_VEIN_NORMAL, ItemAtomicDisassembler.DisassemblerMode.VEIN.icon(), EnumColor.AQUA), new BasicRadialMode(MekanismLang.RADIAL_VEIN_EXTENDED, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_RADIAL, "vein_extended.png"), EnumColor.PINK));
    private static final RadialData<IRadialMode> RADIAL_DATA = IRadialDataHelper.INSTANCE.booleanBasedData(Mekanism.rl("vein_mining_mode"), RADIAL_MODES);
    private static final NestedRadialMode NESTED_RADIAL_MODE = new NestedRadialMode(RADIAL_DATA, MekanismLang.RADIAL_VEIN, ItemAtomicDisassembler.DisassemblerMode.VEIN.icon(), EnumColor.AQUA);

    public ModuleVeinMiningUnit(IModule<ModuleVeinMiningUnit> module) {
        this(module.getBooleanConfigOrFalse(EXTENDED_MODE), (ExcavationRange)module.getConfigOrThrow(EXCAVATION_RANGE).get());
    }

    @Override
    public void addRadialModes(IModule<ModuleVeinMiningUnit> module, @NotNull ItemStack stack, Consumer<NestedRadialMode> adder) {
        if (MekanismConfig.gear.mekaToolExtendedMining.get()) {
            adder.accept(NESTED_RADIAL_MODE);
        }
    }

    @Override
    @Nullable
    public <MODE extends IRadialMode> MODE getMode(IModule<ModuleVeinMiningUnit> module, ItemStack stack, RadialData<MODE> radialData) {
        if (radialData == RADIAL_DATA && MekanismConfig.gear.mekaToolExtendedMining.get()) {
            return (MODE)RADIAL_MODES.get(this.extended);
        }
        return null;
    }

    @Override
    public <MODE extends IRadialMode> boolean setMode(IModule<ModuleVeinMiningUnit> module, Player player, IModuleContainer moduleContainer, ItemStack stack, RadialData<MODE> radialData, MODE mode) {
        if (radialData == RADIAL_DATA && MekanismConfig.gear.mekaToolExtendedMining.get() && this.extended == (mode != RADIAL_MODES.trueMode())) {
            this.toggleExtended(module, moduleContainer, stack, (HolderLookup.Provider)player.registryAccess());
        }
        return false;
    }

    private void toggleExtended(IModule<ModuleVeinMiningUnit> module, IModuleContainer moduleContainer, ItemStack stack, HolderLookup.Provider provider) {
        moduleContainer.replaceModuleConfig(provider, stack, module.getDataHolder(), module.getConfigOrThrow(EXTENDED_MODE).with(!this.extended));
    }

    @Override
    public Component getModeScrollComponent(IModule<ModuleVeinMiningUnit> module, ItemStack stack) {
        if (this.extended()) {
            return MekanismLang.RADIAL_VEIN_EXTENDED.translateColored(EnumColor.PINK);
        }
        return MekanismLang.RADIAL_VEIN_NORMAL.translateColored(EnumColor.AQUA);
    }

    @Override
    public void changeMode(IModule<ModuleVeinMiningUnit> module, Player player, IModuleContainer moduleContainer, ItemStack stack, int shift, boolean displayChangeMessage) {
        if (Math.abs(shift) % 2 == 1) {
            if (displayChangeMessage) {
                player.sendSystemMessage(MekanismUtils.logFormat(MekanismLang.MODULE_MODE_CHANGE.translate(MekanismLang.MODULE_EXTENDED_MODE, EnumColor.INDIGO, !this.extended)));
            }
            this.toggleExtended(module, moduleContainer, stack, (HolderLookup.Provider)player.registryAccess());
        }
    }

    public int getExcavationRange() {
        return this.excavationRange.getRange();
    }

    public static boolean canVeinBlock(BlockState state) {
        return !state.is(MekanismBlocks.BOUNDING_BLOCK);
    }

    public static Object2IntMap<BlockPos> findPositions(Level world, Map<BlockPos, BlockState> initial, int extendedRange, Reference2BooleanMap<Block> oreTracker) {
        Object2IntLinkedOpenHashMap found = new Object2IntLinkedOpenHashMap();
        int maxVein = MekanismConfig.gear.disassemblerMiningCount.get();
        int maxCount = initial.size() + maxVein * oreTracker.size();
        LinkedHashMap<BlockPos, BlockState> frontier = new LinkedHashMap<BlockPos, BlockState>(initial);
        TraversalDistance dist = new TraversalDistance(frontier.size());
        while (!frontier.isEmpty()) {
            Iterator iterator = frontier.entrySet().iterator();
            Map.Entry blockEntry = iterator.next();
            iterator.remove();
            BlockPos blockPos = (BlockPos)blockEntry.getKey();
            found.put((Object)blockPos, dist.getDistance());
            if (found.size() >= maxCount) break;
            Block block = ((BlockState)blockEntry.getValue()).getBlock();
            boolean isOre = oreTracker.getBoolean((Object)block);
            if (isOre || extendedRange > dist.getDistance()) {
                for (BlockPos nextPos : BlockPos.betweenClosed((BlockPos)blockPos.offset(-1, -1, -1), (BlockPos)blockPos.offset(1, 1, 1))) {
                    Optional<BlockState> nextState;
                    if (found.containsKey((Object)nextPos) || frontier.containsKey(nextPos) || !(nextState = WorldUtils.getBlockState((BlockGetter)world, nextPos)).isPresent() || !nextState.get().is(block)) continue;
                    frontier.put(nextPos.immutable(), nextState.get());
                    PacketUtils.sendToAllTracking(new PacketLightningRender(PacketLightningRender.LightningPreset.TOOL_AOE, 31 * blockPos.hashCode() + nextPos.hashCode(), blockPos.getCenter(), nextPos.getCenter(), 10), world, blockPos);
                }
            }
            dist.updateDistance(found.size(), frontier.size());
        }
        return found;
    }

    @Override
    public void addHUDStrings(IModule<ModuleVeinMiningUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player, Consumer<Component> hudStringAdder) {
        if (module.isEnabled() && MekanismConfig.gear.mekaToolExtendedMining.get()) {
            hudStringAdder.accept((Component)MekanismLang.MODULE_EXTENDED_ENABLED.translateColored(EnumColor.DARK_GRAY, this.extended ? EnumColor.BRIGHT_GREEN : EnumColor.DARK_RED, this.extended ? MekanismLang.MODULE_ENABLED_LOWER : MekanismLang.MODULE_DISABLED_LOWER));
        }
    }

    @NothingNullByDefault
    public static enum ExcavationRange implements IHasTextComponent,
    StringRepresentable
    {
        OFF(0),
        LOW(2),
        MED(4),
        HIGH(6),
        EXTREME(8);

        public static final Codec<ExcavationRange> CODEC;
        public static final IntFunction<ExcavationRange> BY_ID;
        public static final StreamCodec<ByteBuf, ExcavationRange> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final int range;
        private final Component label;

        private ExcavationRange(int range) {
            this.range = range;
            this.label = TextComponentUtil.getString(Integer.toString(range));
        }

        @Override
        public Component getTextComponent() {
            return this.label;
        }

        public int getRange() {
            return this.range;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ExcavationRange::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ExcavationRange.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    private static class TraversalDistance {
        private int distance = 0;
        private int next;

        public TraversalDistance(int next) {
            this.next = next;
        }

        public void updateDistance(int found, int frontierSize) {
            if (found == this.next) {
                ++this.distance;
                this.next += frontierSize;
            }
        }

        public int getDistance() {
            return this.distance;
        }
    }

    @NothingNullByDefault
    public static class ModuleExtendedModeConfig
    extends ModuleBooleanConfig {
        public static final Codec<ModuleExtendedModeConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("name").forGetter(ModuleConfig::name), (App)Codec.BOOL.fieldOf("value").forGetter(ModuleConfig::get)).apply((Applicative)instance, ModuleExtendedModeConfig::new));
        public static final StreamCodec<ByteBuf, ModuleExtendedModeConfig> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ModuleConfig::name, (StreamCodec)ByteBufCodecs.BOOL, ModuleConfig::get, ModuleExtendedModeConfig::new);

        public ModuleExtendedModeConfig(ResourceLocation name, boolean value) {
            super(name, value);
        }

        @Override
        public StreamCodec<ByteBuf, ModuleConfig<Boolean>> namedStreamCodec(ResourceLocation name) {
            return ByteBufCodecs.BOOL.map(val -> new ModuleExtendedModeConfig(name, (boolean)val), ModuleConfig::get);
        }

        @Override
        public ModuleBooleanConfig with(Boolean value) {
            Objects.requireNonNull(value, "Value cannot be null.");
            if (this.get().equals(value)) {
                return this;
            }
            return new ModuleExtendedModeConfig(this.name(), value);
        }

        @Override
        public Boolean get() {
            return super.get() != false && !this.isConfigDisabled();
        }

        @Override
        public boolean isConfigDisabled() {
            return !MekanismConfig.gear.mekaToolExtendedMining.get();
        }
    }
}

