/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiPredicate;
import mekanism.common.Mekanism;
import mekanism.common.config.IMekanismConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public abstract class CachedValue<T> {
    private final IMekanismConfig config;
    protected final ModConfigSpec.ConfigValue<T> internal;
    private Set<IConfigValueInvalidationListener> invalidationListeners;

    protected CachedValue(IMekanismConfig config, ModConfigSpec.ConfigValue<T> internal) {
        this.config = config;
        this.internal = internal;
        this.config.addCachedValue(this);
    }

    public boolean hasInvalidationListeners() {
        return this.invalidationListeners != null && !this.invalidationListeners.isEmpty();
    }

    public void addInvalidationListener(IConfigValueInvalidationListener listener) {
        if (this.invalidationListeners == null) {
            this.invalidationListeners = new HashSet<IConfigValueInvalidationListener>();
        }
        if (!this.invalidationListeners.add(listener)) {
            Mekanism.logger.warn("Duplicate invalidation listener added");
        }
    }

    public void removeInvalidationListener(IConfigValueInvalidationListener listener) {
        if (this.invalidationListeners == null) {
            Mekanism.logger.warn("Unable to remove specified invalidation listener, no invalidation listeners have been added.");
        } else if (!this.invalidationListeners.remove(listener)) {
            Mekanism.logger.warn("Unable to remove specified invalidation listener.");
        }
    }

    public <DATA> void removeInvalidationListenersMatching(DATA data, BiPredicate<IConfigValueInvalidationListener, DATA> checker) {
        if (this.invalidationListeners != null && !this.invalidationListeners.isEmpty()) {
            Iterator<IConfigValueInvalidationListener> iter = this.invalidationListeners.iterator();
            while (iter.hasNext()) {
                IConfigValueInvalidationListener listener = iter.next();
                if (!checker.test(listener, data)) continue;
                iter.remove();
            }
        }
    }

    protected abstract boolean clearCachedValue(boolean var1);

    public final void clearCache(boolean unloading) {
        if (this.hasInvalidationListeners()) {
            if (!unloading && this.isLoaded() && this.clearCachedValue(true)) {
                this.invalidationListeners.forEach(Runnable::run);
            }
        } else {
            this.clearCachedValue(false);
        }
    }

    protected boolean isLoaded() {
        return this.config.isLoaded();
    }

    @FunctionalInterface
    public static interface IConfigValueInvalidationListener
    extends Runnable {
    }
}

