/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.MekanismConfigTranslations;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedConfigValue;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.config.value.CachedLongValue;
import mekanism.common.config.value.CachedOredictionificatorConfigValue;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.tier.EnergyCubeTier;
import mekanism.common.tier.FluidTankTier;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.ModConfigSpec;

public class GeneralConfig
extends BaseMekanismConfig {
    private final ModConfigSpec configSpec;
    public final BooleanSupplier enableAlphaWarning;
    public final CachedBooleanValue logPackets;
    public final CachedBooleanValue allowChunkloading;
    public final CachedIntValue blockDeactivationDelay;
    public final CachedBooleanValue strictUnboxing;
    public final CachedConfigValue<List<? extends String>> cardboardModBlacklist;
    public final CachedBooleanValue transmitterAlloyUpgrade;
    public final CachedIntValue maxUpgradeMultiplier;
    public final CachedDoubleValue boilerWaterConductivity;
    public final CachedDoubleValue heatPerFuelTick;
    public final CachedIntValue fuelwoodTickMultiplier;
    public final CachedDoubleValue resistiveHeaterEfficiency;
    public final CachedDoubleValue superheatingHeatTransfer;
    public final CachedIntValue maxSolarNeutronActivatorRate;
    public final CachedIntValue fluidItemFillRate;
    public final CachedLongValue chemicalItemFillRate;
    public final CachedIntValue fluidAutoEjectRate;
    public final CachedLongValue chemicalAutoEjectRate;
    public final CachedDoubleValue dumpExcessKeepRatio;
    public final CachedIntValue dynamicTankFluidPerTank;
    public final CachedLongValue dynamicTankChemicalPerTank;
    public final CachedBooleanValue prefilledFluidTanks;
    public final CachedBooleanValue prefilledChemicalTanks;
    public final CachedBooleanValue blacklistForge;
    public final CachedDoubleValue forgeConversionRate;
    public final CachedBooleanValue blacklistFluxNetworks;
    public final CachedBooleanValue blacklistGrandPower;
    public final CachedLongValue maxEnergyPerSteam;
    public final CachedBooleanValue radiationEnabled;
    public final CachedIntValue radiationChunkCheckRadius;
    public final CachedDoubleValue radiationSourceDecayRate;
    public final CachedDoubleValue radiationTargetDecayRate;
    public final CachedDoubleValue radiationNegativeEffectsMinSeverity;
    public final CachedLongValue radioactiveWasteBarrelMaxChemical;
    public final CachedIntValue radioactiveWasteBarrelProcessTicks;
    public final CachedLongValue radioactiveWasteBarrelDecayAmount;
    public final CachedIntValue minerSilkMultiplier;
    public final CachedIntValue minerMaxRadius;
    public final CachedIntValue minerTicksPerMine;
    public final CachedBooleanValue easyMinerFilters;
    public final CachedBooleanValue aestheticWorldDamage;
    public final CachedIntValue laserRange;
    public final CachedLongValue laserEnergyPerHardness;
    public final CachedLongValue laserEnergyPerDamage;
    public final CachedOredictionificatorConfigValue validOredictionificatorFilters;
    public final CachedIntValue maxPumpRange;
    public final CachedBooleanValue pumpInfiniteFluidSources;
    public final CachedIntValue pumpHeavyWaterAmount;
    public final CachedIntValue maxPlenisherNodes;
    public final CachedLongValue entangloporterEnergyBuffer;
    public final CachedIntValue entangloporterFluidBuffer;
    public final CachedLongValue entangloporterChemicalBuffer;
    public final CachedBooleanValue allowProtection;
    public final CachedBooleanValue opsBypassRestrictions;
    public final CachedFloatValue nutritionalPasteSaturation;
    public final CachedIntValue nutritionalPasteMBPerFood;
    public final CachedIntValue boilerWaterPerTank;
    public final CachedLongValue boilerSteamPerTank;
    public final CachedLongValue boilerHeatedCoolantPerTank;
    public final CachedLongValue boilerCooledCoolantPerTank;
    public final CachedDoubleValue evaporationHeatDissipation;
    public final CachedDoubleValue evaporationTempMultiplier;
    public final CachedDoubleValue evaporationSolarMultiplier;
    public final CachedDoubleValue evaporationHeatCapacity;
    public final CachedIntValue evaporationFluidPerTank;
    public final CachedIntValue evaporationOutputTankCapacity;
    public final CachedIntValue spsInputPerAntimatter;
    public final CachedLongValue spsOutputTankCapacity;
    public final CachedLongValue spsEnergyPerInput;

    GeneralConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        this.enableAlphaWarning = FMLEnvironment.production ? ConstantPredicates.ALWAYS_TRUE : CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GENERAL_ALPHA_WARNING.applyToBuilder(builder).define("alphaWarning", true));
        this.logPackets = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GENERAL_PACKET_LOGGING.applyToBuilder(builder).define("logPackets", false));
        this.allowChunkloading = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GENERAL_CHUNKLOADING.applyToBuilder(builder).define("allowChunkloading", true));
        this.blockDeactivationDelay = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_DEACTIVATION_DELAY.applyToBuilder(builder).defineInRange("blockDeactivationDelay", 60, 0, 1200));
        this.aestheticWorldDamage = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GENERAL_AESTHETIC_DAMAGE.applyToBuilder(builder).define("aestheticWorldDamage", true));
        this.transmitterAlloyUpgrade = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GENERAL_ALLOY_UPGRADING.applyToBuilder(builder).define("transmitterAlloyUpgrade", true));
        this.maxUpgradeMultiplier = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_UPGRADE_MULTIPLIER.applyToBuilder(builder).defineInRange("maxUpgradeMultiplier", 10, 1, Integer.MAX_VALUE));
        this.maxSolarNeutronActivatorRate = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_RATE_SNA.applyToBuilder(builder).defineInRange("maxSolarNeutronActivatorRate", 64, 1, 1024));
        MekanismConfigTranslations.GENERAL_HEATER.applyToBuilder(builder).push("heater");
        this.heatPerFuelTick = CachedDoubleValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GENERAL_FUELWOOD_HEAT.applyToBuilder(builder).defineInRange("heatPerFuelTick", 400.0, 0.1, 4000000.0));
        this.fuelwoodTickMultiplier = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_FUELWOOD_DURATION.applyToBuilder(builder).defineInRange("fuelwoodTickMultiplier", 1, 1, 1000));
        this.resistiveHeaterEfficiency = CachedDoubleValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GENERAL_RESISTIVE_EFFICIENCY.applyToBuilder(builder).defineInRange("resistiveEfficiency", 0.6, 0.0, 1.0));
        builder.pop();
        MekanismConfigTranslations.GENERAL_CARDBOARD.applyToBuilder(builder).push("cardboard_box");
        this.strictUnboxing = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GENERAL_CARDBOARD_STRICT_UNBOXING.applyToBuilder(builder).define("strictUnboxing", false));
        this.cardboardModBlacklist = CachedConfigValue.wrap(this, MekanismConfigTranslations.GENERAL_CARDBOARD_MOD_BLACKLIST.applyToBuilder(builder).defineListAllowEmpty("modBlacklist", ArrayList::new, () -> "mekanism", e -> {
            String modid;
            return e instanceof String && ResourceLocation.isValidNamespace((String)(modid = (String)e));
        }));
        builder.pop();
        MekanismConfigTranslations.GENERAL_FILL_RATE.applyToBuilder(builder).push("item_fill_rate");
        this.fluidItemFillRate = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_FILL_RATE_FLUID.applyToBuilder(builder).defineInRange("fluid", 1024, 1, Integer.MAX_VALUE));
        this.chemicalItemFillRate = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GENERAL_FILL_RATE_CHEMICAL.applyToBuilder(builder).defineInRange("chemical", 1024L, 1L, Long.MAX_VALUE));
        builder.pop();
        MekanismConfigTranslations.GENERAL_DYNAMIC_TANK.applyToBuilder(builder).push("dynamic_tank");
        int maxVolume = 5832;
        this.dynamicTankFluidPerTank = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_DYNAMIC_TANK_FLUID_CAPACITY.applyToBuilder(builder).defineInRange("fluidPerTank", 350000, 1, Integer.MAX_VALUE / maxVolume));
        this.dynamicTankChemicalPerTank = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GENERAL_DYNAMIC_TANK_CHEMICAL_CAPACITY.applyToBuilder(builder).defineInRange("chemicalPerTank", 16000000L, 1L, Long.MAX_VALUE / (long)maxVolume));
        builder.pop();
        MekanismConfigTranslations.GENERAL_AUTO_EJECT.applyToBuilder(builder).push("auto_eject");
        this.fluidAutoEjectRate = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_AUTO_EJECT_RATE_FLUID.applyToBuilder(builder).defineInRange("fluid", 1024, 1, Integer.MAX_VALUE));
        this.chemicalAutoEjectRate = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GENERAL_AUTO_EJECT_RATE_CHEMICAL.applyToBuilder(builder).defineInRange("chemical", 1024L, 1L, Long.MAX_VALUE));
        this.dumpExcessKeepRatio = CachedDoubleValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GENERAL_AUTO_EJECT_EXCESS.applyToBuilder(builder).defineInRange("dumpExcessKeepRatio", 0.85, 0.001, 1.0));
        builder.pop();
        MekanismConfigTranslations.GENERAL_PREFILLED_TANKS.applyToBuilder(builder).push("prefilled");
        this.prefilledFluidTanks = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GENERAL_PREFILLED_TANKS_FLUID.applyToBuilder(builder).define("fluidTanks", true));
        this.prefilledChemicalTanks = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GENERAL_PREFILLED_TANKS_CHEMICAL.applyToBuilder(builder).define("chemicalTanks", true));
        builder.pop();
        MekanismConfigTranslations.GENERAL_ENERGY_CONVERSION.applyToBuilder(builder).push("energy_conversion");
        this.blacklistForge = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GENERAL_ENERGY_CONVERSION_BLACKLIST_FE.applyToBuilder(builder).worldRestart().define("blacklistForge", false));
        this.forgeConversionRate = CachedDoubleValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GENERAL_ENERGY_CONVERSION_FE.applyToBuilder(builder).defineInRange("feConversionRate", 2.5, 1.0E-4, 10000.0));
        this.blacklistFluxNetworks = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GENERAL_ENERGY_CONVERSION_BLACKLIST_FN.applyToBuilder(builder).worldRestart().define("blacklistFluxNetworks", false));
        this.blacklistGrandPower = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GENERAL_ENERGY_CONVERSION_BLACKLIST_GP.applyToBuilder(builder).worldRestart().define("blacklistGrandPower", false));
        this.maxEnergyPerSteam = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GENERAL_ENERGY_CONVERSION_STEAM, "maxEnergyPerSteam", 10L);
        builder.pop();
        MekanismConfigTranslations.GENERAL_RADIATION.applyToBuilder(builder).push("radiation");
        this.radiationEnabled = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GENERAL_RADIATION_ENABLED.applyToBuilder(builder).define("enabled", true));
        this.radiationChunkCheckRadius = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_RADIATION_CHUNK_RADIUS.applyToBuilder(builder).defineInRange("chunkCheckRadius", 5, 1, 100));
        this.radiationSourceDecayRate = CachedDoubleValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GENERAL_RADIATION_DECAY_RATE_SOURCE.applyToBuilder(builder).defineInRange("sourceDecayRate", 0.9995, 0.0, 1.0));
        this.radiationTargetDecayRate = CachedDoubleValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GENERAL_RADIATION_DECAY_RATE_TARGET.applyToBuilder(builder).defineInRange("targetDecayRate", 0.9995, 0.0, 1.0));
        this.radiationNegativeEffectsMinSeverity = CachedDoubleValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GENERAL_RADIATION_MIN_SEVERITY.applyToBuilder(builder).defineInRange("negativeEffectsMinSeverity", 0.1, 0.0, 1.0));
        this.radioactiveWasteBarrelMaxChemical = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GENERAL_RADIATION_BARREL_CAPACITY.applyToBuilder(builder).defineInRange("wasteBarrelCapacity", 512000L, 1L, Long.MAX_VALUE));
        this.radioactiveWasteBarrelProcessTicks = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_RADIATION_BARREL_DECAY_FREQUENCY.applyToBuilder(builder).defineInRange("wasteBarrelProcessTicks", 20, 1, Integer.MAX_VALUE));
        this.radioactiveWasteBarrelDecayAmount = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GENERAL_RADIATION_BARREL_DECAY_AMOUNT.applyToBuilder(builder).defineInRange("wasteBarrelDecayAmount", 1L, 0L, Long.MAX_VALUE));
        builder.pop();
        MekanismConfigTranslations.GENERAL_MINER.applyToBuilder(builder).push("digital_miner");
        this.minerSilkMultiplier = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_MINER_SILK_MULTIPLIER.applyToBuilder(builder).defineInRange("silkMultiplier", 12, 1, Integer.MAX_VALUE));
        this.minerMaxRadius = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_MINER_MAX_RADIUS.applyToBuilder(builder).defineInRange("maxRadius", 32, 1, Integer.MAX_VALUE));
        this.minerTicksPerMine = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_MINER_TICK_RATE.applyToBuilder(builder).defineInRange("ticksPerMine", 80, 1, Integer.MAX_VALUE));
        this.easyMinerFilters = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GENERAL_MINER_EASY_FILTERS.applyToBuilder(builder).define("easyMinerFilters", false));
        builder.pop();
        MekanismConfigTranslations.GENERAL_LASER.applyToBuilder(builder).push("laser");
        this.laserRange = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_LASER_RANGE.applyToBuilder(builder).defineInRange("range", 64, 1, 1024));
        this.laserEnergyPerHardness = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GENERAL_LASER_ENERGY_HARDNESS, "energyPerHardness", 100000L);
        this.laserEnergyPerDamage = CachedLongValue.definedMin(this, builder, MekanismConfigTranslations.GENERAL_LASER_ENERGY_DAMAGE, "energyPerDamage", 2500L, 1L);
        builder.pop();
        MekanismConfigTranslations.GENERAL_OREDICTIONIFICATOR.applyToBuilder(builder).push("oredictionificator");
        this.validOredictionificatorFilters = CachedOredictionificatorConfigValue.define(this, MekanismConfigTranslations.GENERAL_OREDICTIONIFICATOR_VALID_ITEMS.applyToBuilder(builder), "validItemFilters", () -> Collections.singletonMap("c", List.of("ingots/", "ores/", "dusts/", "nuggets/", "storage_blocks/", "raw_materials/")));
        builder.pop();
        MekanismConfigTranslations.GENERAL_PUMP.applyToBuilder(builder).push("pump");
        this.maxPumpRange = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_PUMP_RANGE.applyToBuilder(builder).defineInRange("range", 80, 1, 512));
        this.pumpInfiniteFluidSources = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GENERAL_PUMP_INFINITE_FLUIDS.applyToBuilder(builder).define("pumpInfiniteFluidSources", false));
        this.pumpHeavyWaterAmount = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_PUMP_HEAVY_WATER.applyToBuilder(builder).defineInRange("heavyWaterAmount", 10, 1, 1000));
        this.maxPlenisherNodes = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_PUMP_PLENISHER_MAX_NODES.applyToBuilder(builder).defineInRange("maxPlenisherNodes", 4000, 1, 1000000));
        builder.pop();
        MekanismConfigTranslations.GENERAL_QE.applyToBuilder(builder).push("quantum_entangloporter");
        this.entangloporterEnergyBuffer = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GENERAL_QE_BUFFER_ENERGY.applyToBuilder(builder).worldRestart().defineInRange("energyBuffer", EnergyCubeTier.ULTIMATE.getBaseMaxEnergy(), 1L, Long.MAX_VALUE));
        this.entangloporterFluidBuffer = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_QE_BUFFER_FLUID.applyToBuilder(builder).worldRestart().defineInRange("fluidBuffer", FluidTankTier.ULTIMATE.getBaseStorage(), 1, Integer.MAX_VALUE));
        this.entangloporterChemicalBuffer = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GENERAL_QE_BUFFER_CHEMICAL.applyToBuilder(builder).worldRestart().defineInRange("chemicalBuffer", ChemicalTankTier.ULTIMATE.getBaseStorage(), 1L, Long.MAX_VALUE));
        builder.pop();
        MekanismConfigTranslations.GENERAL_SECURITY.applyToBuilder(builder).push("security");
        this.allowProtection = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GENERAL_SECURITY_ENABLED.applyToBuilder(builder).define("allowProtection", true));
        this.opsBypassRestrictions = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GENERAL_SECURITY_OPS_BYPASS.applyToBuilder(builder).define("opsBypassRestrictions", false));
        builder.pop();
        MekanismConfigTranslations.GENERAL_PASTE.applyToBuilder(builder).push("nutritional_paste");
        this.nutritionalPasteSaturation = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GENERAL_PASTE_SATURATION.applyToBuilder(builder).defineInRange("saturation", 0.8, 0.0, 100.0));
        this.nutritionalPasteMBPerFood = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_PASTE_PER_FOOD.applyToBuilder(builder).defineInRange("mbPerFood", 50, 1, Integer.MAX_VALUE));
        builder.pop();
        MekanismConfigTranslations.GENERAL_BOILER.applyToBuilder(builder).push("boiler");
        this.boilerWaterPerTank = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_BOILER_CAPACITY_WATER.applyToBuilder(builder).defineInRange("waterPerTank", 16000, 1, Integer.MAX_VALUE / maxVolume));
        this.boilerSteamPerTank = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GENERAL_BOILER_CAPACITY_STEAM.applyToBuilder(builder).defineInRange("steamPerTank", 160000L, 10L, Long.MAX_VALUE / (long)maxVolume));
        this.boilerHeatedCoolantPerTank = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GENERAL_BOILER_CAPACITY_HEATED_COOLANT.applyToBuilder(builder).defineInRange("heatedCoolantPerTank", 256000L, 1L, Long.MAX_VALUE / (long)maxVolume));
        this.boilerCooledCoolantPerTank = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GENERAL_BOILER_CAPACITY_COOLED_COOLANT.applyToBuilder(builder).defineInRange("cooledCoolantPerTank", 256000L, 1L, Long.MAX_VALUE / (long)maxVolume));
        this.boilerWaterConductivity = CachedDoubleValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GENERAL_BOILER_WATER_CONDUCTIVITY.applyToBuilder(builder).defineInRange("waterConductivity", 0.7, 0.01, 1.0));
        this.superheatingHeatTransfer = CachedDoubleValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GENERAL_BOILER_HEAT_TRANSFER.applyToBuilder(builder).defineInRange("superheatingHeatTransfer", 1.6E7, 0.1, 1.024E9));
        builder.pop();
        MekanismConfigTranslations.GENERAL_TEP.applyToBuilder(builder).push("thermal_evaporation");
        this.evaporationHeatDissipation = CachedDoubleValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GENERAL_TEP_HEAT_LOSS.applyToBuilder(builder).defineInRange("heatDissipation", 0.02, 0.001, 1000.0));
        this.evaporationSolarMultiplier = CachedDoubleValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GENERAL_TEP_HEAT_SOLAR.applyToBuilder(builder).defineInRange("solarMultiplier", 0.2, 0.001, 1000000.0));
        this.evaporationTempMultiplier = CachedDoubleValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GENERAL_TEP_TEMP_MULT.applyToBuilder(builder).defineInRange("tempMultiplier", 0.4, 0.001, 1000000.0));
        this.evaporationHeatCapacity = CachedDoubleValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GENERAL_TEP_CAPACITY_HEAT.applyToBuilder(builder).defineInRange("heatCapacity", 100.0, 1.0, 1000000.0));
        this.evaporationFluidPerTank = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_TEP_CAPACITY_INPUT.applyToBuilder(builder).defineInRange("fluidPerTank", 64000, 1, 0x1C71C71));
        this.evaporationOutputTankCapacity = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_TEP_CAPACITY_OUTPUT.applyToBuilder(builder).defineInRange("outputTankCapacity", 10000, 1, Integer.MAX_VALUE));
        builder.pop();
        MekanismConfigTranslations.GENERAL_SPS.applyToBuilder(builder).push("sps");
        this.spsInputPerAntimatter = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GENERAL_SPS_ANTIMATTER_COST.applyToBuilder(builder).defineInRange("inputPerAntimatter", 1000, 1, Integer.MAX_VALUE));
        this.spsOutputTankCapacity = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GENERAL_SPS_CAPACITY_OUTPUT.applyToBuilder(builder).defineInRange("outputTankCapacity", 1000L, 1L, Long.MAX_VALUE));
        this.spsEnergyPerInput = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GENERAL_SPS_ENERGY_PER, "energyPerInput", 1000000L);
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public String getFileName() {
        return "general";
    }

    @Override
    public String getTranslation() {
        return "General Config";
    }

    @Override
    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

