/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.proxy;

import mekanism.api.Action;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.ISidedStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.capabilities.holder.IHolder;
import mekanism.common.capabilities.proxy.ProxyHandler;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ProxyStrictEnergyHandler
extends ProxyHandler
implements IStrictEnergyHandler {
    private final ISidedStrictEnergyHandler energyHandler;

    public ProxyStrictEnergyHandler(ISidedStrictEnergyHandler energyHandler, @Nullable Direction side, @Nullable IHolder holder) {
        super(side, holder);
        this.energyHandler = energyHandler;
    }

    @Override
    public int getEnergyContainerCount() {
        return this.energyHandler.getEnergyContainerCount(this.side);
    }

    @Override
    public long getEnergy(int container) {
        return this.energyHandler.getEnergy(container, this.side);
    }

    @Override
    public void setEnergy(int container, long energy) {
        if (!this.readOnly) {
            this.energyHandler.setEnergy(container, energy, this.side);
        }
    }

    @Override
    public long getMaxEnergy(int container) {
        return this.energyHandler.getMaxEnergy(container, this.side);
    }

    @Override
    public long getNeededEnergy(int container) {
        return this.energyHandler.getNeededEnergy(container, this.side);
    }

    @Override
    public long insertEnergy(int container, long amount, Action action) {
        return this.readOnlyInsert() ? amount : this.energyHandler.insertEnergy(container, amount, this.side, action);
    }

    @Override
    public long extractEnergy(int container, long amount, Action action) {
        return this.readOnlyExtract() ? 0L : this.energyHandler.extractEnergy(container, amount, this.side, action);
    }

    @Override
    public long insertEnergy(long amount, Action action) {
        return this.readOnlyInsert() ? amount : this.energyHandler.insertEnergy(amount, this.side, action);
    }

    @Override
    public long extractEnergy(long amount, Action action) {
        return this.readOnlyExtract() ? 0L : this.energyHandler.extractEnergy(amount, this.side, action);
    }
}

