/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.proxy;

import java.util.Collections;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.api.chemical.ISidedChemicalHandler;
import mekanism.common.capabilities.holder.IHolder;
import mekanism.common.capabilities.proxy.ProxyHandler;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ProxyChemicalHandler
extends ProxyHandler
implements IChemicalHandler {
    private final ISidedChemicalHandler sidedHandler;

    public ProxyChemicalHandler(ISidedChemicalHandler sidedHandler, @Nullable Direction side, @Nullable IHolder holder) {
        super(side, holder);
        this.sidedHandler = sidedHandler;
    }

    public ISidedChemicalHandler getInternalHandler() {
        return this.sidedHandler;
    }

    public List<IChemicalTank> getTanksIfMekanism() {
        ISidedChemicalHandler iSidedChemicalHandler = this.sidedHandler;
        if (iSidedChemicalHandler instanceof IMekanismChemicalHandler) {
            IMekanismChemicalHandler mekHandler = (IMekanismChemicalHandler)iSidedChemicalHandler;
            return mekHandler.getChemicalTanks(null);
        }
        return Collections.emptyList();
    }

    @Override
    public int getChemicalTanks() {
        return this.sidedHandler.getCountChemicalTanks(this.side);
    }

    @Override
    public ChemicalStack getChemicalInTank(int tank) {
        return this.sidedHandler.getChemicalInTank(tank, this.side);
    }

    @Override
    public void setChemicalInTank(int tank, ChemicalStack stack) {
        if (!this.readOnly) {
            this.sidedHandler.setChemicalInTank(tank, stack, this.side);
        }
    }

    @Override
    public long getChemicalTankCapacity(int tank) {
        return this.sidedHandler.getChemicalTankCapacity(tank, this.side);
    }

    @Override
    public boolean isValid(int tank, ChemicalStack stack) {
        return !this.readOnly || this.sidedHandler.isValid(tank, stack, this.side);
    }

    @Override
    public ChemicalStack insertChemical(int tank, ChemicalStack stack, Action action) {
        return this.readOnlyInsert() ? stack : this.sidedHandler.insertChemical(tank, stack, this.side, action);
    }

    @Override
    public ChemicalStack extractChemical(int tank, long amount, Action action) {
        return this.readOnlyExtract() ? ChemicalStack.EMPTY : this.sidedHandler.extractChemical(tank, amount, this.side, action);
    }

    @Override
    public ChemicalStack insertChemical(ChemicalStack stack, Action action) {
        return this.readOnlyInsert() ? stack : this.sidedHandler.insertChemical(stack, this.side, action);
    }

    @Override
    public ChemicalStack extractChemical(long amount, Action action) {
        return this.readOnlyExtract() ? ChemicalStack.EMPTY : this.sidedHandler.extractChemical(amount, this.side, action);
    }

    @Override
    public ChemicalStack extractChemical(ChemicalStack stack, Action action) {
        return this.readOnlyExtract() ? ChemicalStack.EMPTY : this.sidedHandler.extractChemical(stack, this.side, action);
    }
}

