/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.chemical;

import java.util.Objects;
import java.util.function.LongSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.tier.ChemicalTankTier;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ChemicalTankChemicalTank
extends BasicChemicalTank {
    private final boolean isCreative;
    private final LongSupplier rate;

    public static ChemicalTankChemicalTank create(ChemicalTankTier tier, @Nullable IContentsListener listener) {
        Objects.requireNonNull(tier, "Chemical tank tier cannot be null");
        return new ChemicalTankChemicalTank(tier, listener);
    }

    private ChemicalTankChemicalTank(ChemicalTankTier tier, @Nullable IContentsListener listener) {
        super(tier.getStorage(), ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrue(), tier == ChemicalTankTier.CREATIVE ? ChemicalAttributeValidator.ALWAYS_ALLOW : null, listener, null);
        this.isCreative = tier == ChemicalTankTier.CREATIVE;
        this.rate = tier::getOutput;
    }

    @Override
    protected long getInsertRate(@Nullable AutomationType automationType) {
        return automationType == AutomationType.INTERNAL ? this.rate.getAsLong() : super.getInsertRate(automationType);
    }

    @Override
    protected long getExtractRate(@Nullable AutomationType automationType) {
        return automationType == AutomationType.INTERNAL ? this.rate.getAsLong() : super.getExtractRate(automationType);
    }

    @Override
    public ChemicalStack insert(ChemicalStack stack, Action action, AutomationType automationType) {
        if (this.isCreative && this.isEmpty() && action.execute() && automationType != AutomationType.EXTERNAL) {
            ChemicalStack simulatedRemainder = super.insert(stack, Action.SIMULATE, automationType);
            if (simulatedRemainder.isEmpty()) {
                this.setStackUnchecked(stack.copyWithAmount(this.getCapacity()));
            }
            return simulatedRemainder;
        }
        return super.insert(stack, action.combine(!this.isCreative), automationType);
    }

    @Override
    public ChemicalStack extract(long amount, Action action, AutomationType automationType) {
        return super.extract(amount, action.combine(!this.isCreative), automationType);
    }

    @Override
    public long setStackSize(long amount, Action action) {
        return super.setStackSize(amount, action.combine(!this.isCreative));
    }
}

