/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.energy;

import java.util.function.LongSupplier;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.common.attachments.containers.ComponentBackedContainer;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.energy.AttachedEnergy;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@NothingNullByDefault
public class ComponentBackedEnergyContainer
extends ComponentBackedContainer<Long, AttachedEnergy>
implements IEnergyContainer {
    private final Predicate<@NotNull AutomationType> canExtract;
    private final Predicate<@NotNull AutomationType> canInsert;
    private final LongSupplier maxEnergy;
    private final LongSupplier rate;

    public ComponentBackedEnergyContainer(ItemStack attachedTo, int containerIndex, Predicate<@NotNull AutomationType> canExtract, Predicate<@NotNull AutomationType> canInsert, LongSupplier rate, LongSupplier maxEnergy) {
        super(attachedTo, containerIndex);
        this.canExtract = canExtract;
        this.canInsert = canInsert;
        this.maxEnergy = maxEnergy;
        this.rate = rate;
    }

    @Override
    protected Long copy(Long toCopy) {
        return toCopy;
    }

    @Override
    protected boolean isEmpty(Long value) {
        return value <= 0L;
    }

    @Override
    protected ContainerType<?, AttachedEnergy, ?> containerType() {
        return ContainerType.ENERGY;
    }

    @Override
    public long getEnergy() {
        return (Long)this.getContents((AttachedEnergy)this.getAttached());
    }

    @Override
    public void setEnergy(long energy) {
        this.setContents((AttachedEnergy)this.getAttached(), energy);
    }

    protected long clampEnergy(long energy) {
        return Math.min(energy, this.getMaxEnergy());
    }

    @Override
    protected void setContents(AttachedEnergy attachedEnergy, Long energy) {
        super.setContents(attachedEnergy, this.clampEnergy(energy));
    }

    protected @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getInsertRate(@Nullable AutomationType automationType) {
        return automationType == null || automationType == AutomationType.MANUAL ? Long.MAX_VALUE : this.rate.getAsLong();
    }

    protected @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getExtractRate(@Nullable AutomationType automationType) {
        return automationType == null || automationType == AutomationType.MANUAL ? Long.MAX_VALUE : this.rate.getAsLong();
    }

    @Override
    public long insert(long amount, Action action, AutomationType automationType) {
        if (amount <= 0L || !this.canInsert.test(automationType)) {
            return amount;
        }
        AttachedEnergy attachedEnergy = (AttachedEnergy)this.getAttached();
        long stored = (Long)this.getContents(attachedEnergy);
        long needed = Math.min(this.getInsertRate(automationType), this.getNeeded(stored));
        if (needed == 0L) {
            return amount;
        }
        long toAdd = Math.min(amount, needed);
        if (action.execute()) {
            this.setContents(attachedEnergy, stored + toAdd);
        }
        return amount - toAdd;
    }

    @Override
    public long extract(long amount, Action action, AutomationType automationType) {
        if (amount <= 0L) {
            return 0L;
        }
        AttachedEnergy attachedEnergy = (AttachedEnergy)this.getAttached();
        long stored = (Long)this.getContents(attachedEnergy);
        if (stored == 0L || !this.canExtract.test(automationType)) {
            return 0L;
        }
        long ret = Math.min(Math.min(this.getExtractRate(automationType), stored), amount);
        if (ret > 0L && action.execute()) {
            this.setContents(attachedEnergy, stored - ret);
        }
        return ret;
    }

    protected @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getNeeded(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long stored) {
        return this.getMaxEnergy() - stored;
    }

    @Override
    public long getMaxEnergy() {
        return this.maxEnergy.getAsLong();
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        long stored = this.getEnergy();
        if (stored > 0L) {
            nbt.putLong("stored", stored);
        }
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        NBTUtils.setLegacyEnergyIfPresent(nbt, "stored", this::setEnergy);
    }
}

