/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;

public class IncompleteRecipeScanner {
    private static final Component RECIPE_WARNING = MekanismLang.LOG_FORMAT.translateColored(EnumColor.RED, MekanismLang.MEKANISM, MekanismLang.RECIPE_WARNING.translate());
    private static boolean foundIncompleteRecipes = false;

    @SubscribeEvent
    public static void recipes(OnDatapackSyncEvent event) {
        List players;
        ServerPlayer player = event.getPlayer();
        if (player != null) {
            if (foundIncompleteRecipes) {
                IncompleteRecipeScanner.sendMessageToPlayer(player);
            }
            return;
        }
        foundIncompleteRecipes = MekanismRecipeType.checkIncompleteRecipes(event.getPlayerList().getServer());
        if (foundIncompleteRecipes && !(players = event.getPlayerList().getPlayers()).isEmpty()) {
            players.forEach(IncompleteRecipeScanner::sendMessageToPlayer);
        }
    }

    private static void sendMessageToPlayer(ServerPlayer player) {
        player.sendSystemMessage(RECIPE_WARNING);
    }

    @SubscribeEvent
    public static void serverStarted(ServerStartedEvent event) {
        foundIncompleteRecipes = MekanismRecipeType.checkIncompleteRecipes(event.getServer());
    }
}

