/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.Map;
import java.util.Optional;
import java.util.function.LongSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.MekanismAPITags;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.functions.FloatSupplier;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.math.MathUtils;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.IBlastingItem;
import mekanism.common.content.gear.mekasuit.ModuleGravitationalModulatingUnit;
import mekanism.common.content.gear.mekasuit.ModuleHydraulicPropulsionUnit;
import mekanism.common.content.gear.mekasuit.ModuleLocomotiveBoostingUnit;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.gear.ItemScubaMask;
import mekanism.common.item.gear.ItemScubaTank;
import mekanism.common.item.interfaces.IFreeRunnerItem;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.lib.radiation.PlayerExposure;
import mekanism.common.registries.MekanismDamageTypes;
import mekanism.common.registries.MekanismGameEvents;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.Nullable;

public class CommonPlayerTickHandler {
    public static boolean isOnGroundOrSleeping(Player player) {
        return player.onGround() || player.isSleeping() || player.getAbilities().flying;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isScubaMaskOn(Player player, ItemStack tank) {
        ItemStack mask = player.getItemBySlot(EquipmentSlot.HEAD);
        if (tank.isEmpty()) return false;
        if (mask.isEmpty()) return false;
        Item item = tank.getItem();
        if (!(item instanceof ItemScubaTank)) return false;
        ItemScubaTank scubaTank = (ItemScubaTank)item;
        if (!(mask.getItem() instanceof ItemScubaMask)) return false;
        if (!ChemicalUtil.hasAnyChemical(tank)) return false;
        if ((Boolean)scubaTank.getMode(tank) == false) return false;
        return true;
    }

    public static float getStepBoost(Player player) {
        if (player.isShiftKeyDown()) {
            return 0.0f;
        }
        ItemStack stack = player.getItemBySlot(EquipmentSlot.FEET);
        if (stack.isEmpty()) {
            return 0.0f;
        }
        IModule hydraulic = IModuleHelper.INSTANCE.getIfEnabled(stack, MekanismModules.HYDRAULIC_PROPULSION_UNIT);
        if (hydraulic != null) {
            return ((ModuleHydraulicPropulsionUnit)hydraulic.getCustomInstance()).getStepHeight();
        }
        ItemStack primaryFreeRunners = IFreeRunnerItem.getPrimaryFreeRunners((LivingEntity)player);
        if (!primaryFreeRunners.isEmpty() && ((IFreeRunnerItem)primaryFreeRunners.getItem()).getFreeRunnerMode(primaryFreeRunners).providesStepBoost()) {
            return 0.5f;
        }
        return 0.0f;
    }

    @SubscribeEvent
    public void onTick(PlayerTickEvent.Post event) {
        if (!event.getEntity().level().isClientSide()) {
            this.tickEnd(event.getEntity());
        }
    }

    private void tickEnd(Player player) {
        ItemStack chest;
        IJetpackItem jetpackItem;
        IJetpackItem.JetpackMode primaryMode;
        IJetpackItem.JetpackMode mode;
        ItemStack primaryJetpack;
        ItemStack jetpack;
        Mekanism.playerState.updateStepAssist(player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerExposure.tickServer(serverPlayer);
        }
        if (!(jetpack = IJetpackItem.getActiveJetpack((LivingEntity)player)).isEmpty() && !(primaryJetpack = IJetpackItem.getPrimaryJetpack((LivingEntity)player)).isEmpty() && (mode = IJetpackItem.getPlayerJetpackMode(player, primaryMode = (jetpackItem = (IJetpackItem)primaryJetpack.getItem()).getJetpackMode(primaryJetpack), p -> Mekanism.keyMap.has(p.getUUID(), 0))) != IJetpackItem.JetpackMode.DISABLED) {
            double jetpackThrust = jetpackItem.getJetpackThrust(primaryJetpack);
            if (IJetpackItem.handleJetpackMotion(player, mode, jetpackThrust, p -> Mekanism.keyMap.has(p.getUUID(), 0))) {
                player.resetFallDistance();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.connection.aboveGroundTickCount = 0;
                }
            }
            ((IJetpackItem)jetpack.getItem()).useJetpackFuel(jetpack);
            if (player.level().getGameTime() % 10L == 0L) {
                player.gameEvent(MekanismGameEvents.JETPACK_BURN);
            }
        }
        if (CommonPlayerTickHandler.isScubaMaskOn(player, chest = player.getItemBySlot(EquipmentSlot.CHEST))) {
            ItemScubaTank tank = (ItemScubaTank)chest.getItem();
            int max = player.getMaxAirSupply();
            tank.useChemical(chest, 1L);
            ChemicalStack received = tank.useChemical(chest, max - player.getAirSupply());
            if (!received.isEmpty()) {
                player.setAirSupply(player.getAirSupply() + (int)received.getAmount());
            }
            if (player.getAirSupply() == max) {
                for (MobEffectInstance effect : player.getActiveEffects()) {
                    if (!MekanismUtils.shouldSpeedUpEffect(effect)) continue;
                    for (int i = 0; i < 9; ++i) {
                        MekanismUtils.speedUpEffectSafely((LivingEntity)player, effect);
                    }
                }
            }
        }
    }

    public static boolean isGravitationalModulationOn(Player player) {
        if (ModuleGravitationalModulatingUnit.shouldProcess(player)) {
            ItemStack stack = player.getItemBySlot(EquipmentSlot.CHEST);
            IModule module = IModuleHelper.INSTANCE.getIfEnabled(stack, MekanismModules.GRAVITATIONAL_MODULATING_UNIT);
            return module != null && module.hasEnoughEnergy(stack, MekanismConfig.gear.mekaSuitEnergyUsageGravitationalModulation);
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingDeath(LivingDeathEvent event) {
        if (!event.getEntity().isOnFire() && !event.getEntity().fireImmune() && MekanismDamageTypes.FLAMETHROWER.is(event.getSource())) {
            event.getEntity().igniteForSeconds(1.0f);
        }
    }

    @SubscribeEvent
    public void checkEntityInvulnerability(EntityInvulnerabilityCheckEvent event) {
        Entity entity;
        if (!event.isInvulnerable() && (entity = event.getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (MekanismDamageTypes.RADIATION.is(event.getSource())) {
                event.setInvulnerable(entity2.getType().is(MekanismAPITags.Entities.MEK_RADIATION_IMMUNE));
            }
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingIncomingDamageEvent event) {
        Player player;
        float ratioAbsorbed;
        ItemScubaTank tank;
        Item item;
        ItemStack chestStack;
        ItemStack headStack;
        LivingEntity entity = event.getEntity();
        DamageContainer damageContainer = event.getContainer();
        float damage = damageContainer.getNewDamage();
        if (damage <= 0.0f || !entity.isAlive()) {
            return;
        }
        DamageSource source = damageContainer.getSource();
        if (source.is(MekanismAPITags.DamageTypes.IS_PREVENTABLE_MAGIC) && !(headStack = entity.getItemBySlot(EquipmentSlot.HEAD)).isEmpty() && headStack.getItem() instanceof ItemScubaMask && !(chestStack = entity.getItemBySlot(EquipmentSlot.CHEST)).isEmpty() && (item = chestStack.getItem()) instanceof ItemScubaTank && ((Boolean)(tank = (ItemScubaTank)item).getMode(chestStack)).booleanValue() && ChemicalUtil.hasAnyChemical(chestStack)) {
            event.setCanceled(true);
            return;
        }
        if (entity instanceof Player && (ratioAbsorbed = ItemMekaSuitArmor.getDamageAbsorbed(player = (Player)entity, damageContainer.getSource(), damage)) > 0.0f) {
            float damageRemaining = damage * Math.max(0.0f, 1.0f - ratioAbsorbed);
            if (damageRemaining <= 0.0f) {
                event.setCanceled(true);
            } else {
                damageContainer.setNewDamage(damageRemaining);
            }
        }
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        float safeFallDistance = (float)entity.getAttributeValue(Attributes.SAFE_FALL_DISTANCE);
        float fallDistance = Math.max(event.getDistance() - safeFallDistance, 0.0f);
        if (fallDistance <= 1.0E-5f) {
            return;
        }
        double damageMultiplier = (double)event.getDamageMultiplier() * entity.getAttributeValue(Attributes.FALL_DAMAGE_MULTIPLIER);
        int fallDamage = Mth.ceil((double)((double)fallDistance * damageMultiplier));
        if (fallDamage <= 0) {
            return;
        }
        FallEnergyInfo info = this.getFallAbsorptionEnergyInfo(entity);
        if (info != null && info.container != null) {
            float ratioAbsorbed;
            float absorption = info.damageRatio.getAsFloat();
            float amount = (float)fallDamage * absorption;
            long energyRequirement = MathUtils.ceilToLong((float)info.energyCost.getAsLong() * amount);
            if (energyRequirement == 0L) {
                ratioAbsorbed = absorption;
            } else {
                long extracted = info.container.extract(energyRequirement, Action.EXECUTE, AutomationType.MANUAL);
                ratioAbsorbed = (float)((double)absorption * ((double)extracted / (double)energyRequirement));
            }
            if (ratioAbsorbed > 0.0f) {
                float damageRemaining = (float)fallDamage * Math.max(0.0f, 1.0f - ratioAbsorbed);
                if (damageRemaining <= 1.0E-5f) {
                    event.setCanceled(true);
                    BlockPos posOn = entity.getOnPos();
                    BlockState stateOn = entity.level().getBlockState(posOn);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.playStepSound(posOn, stateOn);
                    } else {
                        SoundType soundtype = stateOn.getSoundType((LevelReader)entity.level(), posOn, (Entity)entity);
                        entity.playSound(soundtype.getStepSound(), soundtype.getVolume() * 0.15f, soundtype.getPitch());
                    }
                } else {
                    float distanceRemaining = (float)((double)damageRemaining / damageMultiplier);
                    event.setDistance(distanceRemaining + safeFallDistance);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        ItemStack boots;
        IModule propulsionModule;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (propulsionModule = IModuleHelper.INSTANCE.getIfEnabled(boots = (player = (Player)livingEntity).getItemBySlot(EquipmentSlot.FEET), MekanismModules.HYDRAULIC_PROPULSION_UNIT)) != null && Mekanism.keyMap.has(player.getUUID(), 1)) {
            float boost = ((ModuleHydraulicPropulsionUnit)propulsionModule.getCustomInstance()).getBoost();
            long usage = MathUtils.ceilToLong((float)MekanismConfig.gear.mekaSuitBaseJumpEnergyUsage.get() * boost / 0.1f);
            if (propulsionModule.canUseEnergy((LivingEntity)player, boots, usage)) {
                ItemStack legs = player.getItemBySlot(EquipmentSlot.LEGS);
                IModule<ModuleLocomotiveBoostingUnit> boostModule = IModuleHelper.INSTANCE.getIfEnabled(legs, MekanismModules.LOCOMOTIVE_BOOSTING_UNIT);
                if (boostModule != null && ((ModuleLocomotiveBoostingUnit)boostModule.getCustomInstance()).canFunction(boostModule, legs, player)) {
                    boost = Mth.sqrt((float)boost);
                }
                player.addDeltaMovement(new Vec3(0.0, (double)boost, 0.0));
                propulsionModule.useEnergy((LivingEntity)player, legs, usage, true);
            }
        }
    }

    @Nullable
    private FallEnergyInfo getFallAbsorptionEnergyInfo(LivingEntity base) {
        ItemStack primaryFreeRunners;
        ItemStack feetStack = base.getItemBySlot(EquipmentSlot.FEET);
        if (!feetStack.isEmpty() && feetStack.getItem() instanceof ItemMekaSuitArmor) {
            return new FallEnergyInfo(StorageUtils.getEnergyContainer(feetStack, 0), MekanismConfig.gear.mekaSuitFallDamageRatio, MekanismConfig.gear.mekaSuitEnergyUsageFall);
        }
        ItemStack freeRunners = IFreeRunnerItem.getActiveFreeRunners(base);
        if (!freeRunners.isEmpty() && !(primaryFreeRunners = IFreeRunnerItem.getPrimaryFreeRunners(base)).isEmpty() && ((IFreeRunnerItem)primaryFreeRunners.getItem()).getFreeRunnerMode(primaryFreeRunners).preventsFallDamage()) {
            return new FallEnergyInfo(((IFreeRunnerItem)freeRunners.getItem()).getRunnerEnergyContainer(freeRunners), MekanismConfig.gear.freeRunnerFallDamageRatio, MekanismConfig.gear.freeRunnerFallEnergyCost);
        }
        return null;
    }

    @SubscribeEvent
    public void getBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        float speed = event.getNewSpeed();
        Optional position = event.getPosition();
        if (position.isPresent()) {
            IBlastingItem tool;
            Map<BlockPos, BlockState> blocks;
            Item item;
            BlockPos pos = (BlockPos)position.get();
            ItemStack mainHand = player.getMainHandItem();
            if (!mainHand.isEmpty() && (item = mainHand.getItem()) instanceof IBlastingItem && !(blocks = (tool = (IBlastingItem)item).getBlastedBlocks(player.level(), player, mainHand, pos, event.getState())).isEmpty()) {
                float targetHardness;
                float maxHardness = targetHardness = event.getState().getDestroySpeed((BlockGetter)player.level(), pos);
                for (Map.Entry<BlockPos, BlockState> entry : blocks.entrySet()) {
                    float destroySpeed = entry.getValue().getDestroySpeed((BlockGetter)player.level(), entry.getKey());
                    maxHardness = Math.max(maxHardness, destroySpeed);
                }
                speed *= targetHardness / maxHardness;
            }
        }
        if (!player.onGround() && IModuleHelper.INSTANCE.isEnabled(player.getItemBySlot(EquipmentSlot.LEGS), (Holder<ModuleData<?>>)MekanismModules.GYROSCOPIC_STABILIZATION_UNIT)) {
            speed *= 5.0f;
        }
        event.setNewSpeed(speed);
    }

    private record FallEnergyInfo(@Nullable IEnergyContainer container, FloatSupplier damageRatio, LongSupplier energyCost) {
    }
}

