/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei.machine;

import java.util.List;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ItemStackChemicalToItemStackRecipe;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiEmptyBar;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.jei.HolderRecipeCategory;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class ItemStackChemicalToItemStackRecipeCategory
extends HolderRecipeCategory<ItemStackChemicalToItemStackRecipe> {
    private final GuiBar<?> chemicalInput;
    private final GuiSlot input = this.addSlot(SlotType.INPUT, 64, 17);
    private final GuiSlot extra = this.addSlot(SlotType.EXTRA, 64, 53);
    private final GuiSlot output = this.addSlot(SlotType.OUTPUT, 116, 35);

    public ItemStackChemicalToItemStackRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<ItemStackChemicalToItemStackRecipe> recipeType) {
        super(helper, recipeType);
        this.addSlot(SlotType.POWER, 39, 35).with(SlotOverlay.POWER);
        this.addElement(new GuiVerticalPowerBar((IGuiWrapper)this, RecipeViewerUtils.FULL_BAR, 164, 16));
        this.chemicalInput = this.addElement(new GuiEmptyBar(this, 68, 36, 6, 12));
        this.addSimpleProgress(ProgressType.BAR, 86, 38);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, RecipeHolder<ItemStackChemicalToItemStackRecipe> recipeHolder, @NotNull IFocusGroup focusGroup) {
        ItemStackChemicalToItemStackRecipe recipe = (ItemStackChemicalToItemStackRecipe)recipeHolder.value();
        this.initItem(builder, RecipeIngredientRole.INPUT, this.input, recipe.getItemInput().getRepresentations());
        List<ChemicalStack> scaledChemicals = recipe.getChemicalInput().getRepresentations();
        if (recipe.perTickUsage()) {
            scaledChemicals = scaledChemicals.stream().map(chemical -> chemical.copyWithAmount(chemical.getAmount() * 200L)).toList();
        }
        this.initChemical(builder, RecipeIngredientRole.INPUT, this.chemicalInput, scaledChemicals);
        this.initItem(builder, RecipeIngredientRole.OUTPUT, this.output, recipe.getOutputDefinition());
        this.initItem(builder, RecipeIngredientRole.CATALYST, this.extra, RecipeViewerUtils.getStacksFor(recipe.getChemicalInput(), true));
    }
}

