/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import java.util.List;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.progress.GuiFlame;
import mekanism.client.gui.element.progress.IProgressInfoHandler;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.client.gui.element.tab.GuiWarningTab;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.IWarningTracker;
import mekanism.common.tile.machine.TileEntityFuelwoodHeater;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiFuelwoodHeater
extends GuiMekanismTile<TileEntityFuelwoodHeater, MekanismTileContainer<TileEntityFuelwoodHeater>> {
    public GuiFuelwoodHeater(MekanismTileContainer<TileEntityFuelwoodHeater> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 48, 23, 80, 28, () -> List.of(MekanismLang.TEMPERATURE.translate(MekanismUtils.getTemperatureDisplay(((TileEntityFuelwoodHeater)this.tile).getTotalTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true)), MekanismLang.FUEL.translate(((TileEntityFuelwoodHeater)this.tile).burnTime))));
        this.addRenderableWidget(new GuiFlame(new IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return (double)((TileEntityFuelwoodHeater)((GuiFuelwoodHeater)GuiFuelwoodHeater.this).tile).burnTime / (double)((TileEntityFuelwoodHeater)((GuiFuelwoodHeater)GuiFuelwoodHeater.this).tile).maxBurnTime;
            }

            @Override
            public boolean isActive() {
                return ((TileEntityFuelwoodHeater)((GuiFuelwoodHeater)GuiFuelwoodHeater.this).tile).burnTime > 0;
            }
        }, this, 144, 31));
        this.addRenderableWidget(new GuiHeatTab(this, () -> {
            Component temp = MekanismUtils.getTemperatureDisplay(((TileEntityFuelwoodHeater)this.tile).getTotalTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true);
            Component transfer = MekanismUtils.getTemperatureDisplay(((TileEntityFuelwoodHeater)this.tile).getLastTransferLoss(), UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            Component environment = MekanismUtils.getTemperatureDisplay(((TileEntityFuelwoodHeater)this.tile).getLastEnvironmentLoss(), UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            return List.of(MekanismLang.TEMPERATURE.translate(temp), MekanismLang.TRANSFERRED_RATE.translate(transfer), MekanismLang.DISSIPATED_RATE.translate(environment));
        }));
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.renderInventoryText(guiGraphics);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void addWarningTab(IWarningTracker warningTracker) {
        this.addRenderableWidget(new GuiWarningTab(this, warningTracker, false));
    }
}

