/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import mekanism.api.IIncrementalEnum;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.SideDataButton;
import mekanism.client.gui.element.button.TooltipToggleButton;
import mekanism.client.gui.element.tab.GuiConfigTypeTab;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.network.to_server.configuration_update.PacketBatchConfiguration;
import mekanism.common.network.to_server.configuration_update.PacketEjectConfiguration;
import mekanism.common.network.to_server.configuration_update.PacketSideData;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class GuiSideConfiguration<TILE extends TileEntityMekanism>
extends GuiWindow {
    private final List<GuiConfigTypeTab> configTabs = new ArrayList<GuiConfigTypeTab>();
    private final Map<RelativeSide, SideDataButton> sideConfigButtons = new EnumMap<RelativeSide, SideDataButton>(RelativeSide.class);
    private final MekanismButton ejectButton;
    private final TILE tile;
    private TransmissionType currentType;

    public GuiSideConfiguration(IGuiWrapper gui, int x, int y, TILE tile, SelectedWindowData windowData) {
        super(gui, x, y, 156, 135, windowData);
        if (windowData.type != SelectedWindowData.WindowType.SIDE_CONFIG) {
            throw new IllegalArgumentException("Side configs must have a side config window type");
        }
        this.tile = tile;
        this.interactionStrategy = GuiWindow.InteractionStrategy.ALL;
        List<TransmissionType> transmissions = ((ISideConfiguration)this.tile).getConfig().getTransmissions();
        this.setCurrentType(transmissions.getFirst());
        this.addChild(new GuiInnerScreen(gui, this.relativeX + 38, this.relativeY + 25, 80, 12, () -> {
            ConfigInfo config = this.getCurrentConfig();
            if (config == null || !config.canEject()) {
                return Collections.singletonList(MekanismLang.NO_EJECT.translate());
            }
            return Collections.singletonList(MekanismLang.EJECT.translate(BooleanStateDisplay.OnOff.of(config.isEjecting())));
        }).tooltip(() -> {
            ConfigInfo config = this.getCurrentConfig();
            if (config == null || !config.canEject()) {
                return Collections.singletonList(MekanismLang.CANT_EJECT_TOOLTIP.translate());
            }
            return Collections.emptyList();
        }));
        for (int i = 0; i < transmissions.size(); ++i) {
            GuiConfigTypeTab tab = new GuiConfigTypeTab(gui, transmissions.get(i), this.relativeX + (i < 4 ? -26 : this.width), this.relativeY + (2 + 28 * (i % 4)), this, i < 4);
            this.addChild(tab);
            this.configTabs.add(tab);
        }
        this.ejectButton = this.addChild(new MekanismImageButton(gui, this.relativeX + 136, this.relativeY + 6, 14, GuiSideConfiguration.getButtonLocation("auto_eject"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketEjectConfiguration(this.tile.getBlockPos(), this.currentType)))).setTooltip(MekanismLang.AUTO_EJECT);
        this.addChild(new TooltipToggleButton(gui, this.relativeX + 136, this.relativeY + 95, 14, GuiSideConfiguration.getButtonLocation("clear_sides"), () -> this.getTargetType(IIncrementalEnum::getNext) == DataType.NONE, (element, mouseX, mouseY) -> {
            DataType targetType = this.getTargetType(IIncrementalEnum::getNext);
            return PacketUtils.sendToServer(new PacketBatchConfiguration(this.tile.getBlockPos(), Screen.hasShiftDown() ? null : this.currentType, targetType));
        }, (element, mouseX, mouseY) -> {
            DataType targetType = this.getTargetType(IIncrementalEnum::getPrevious);
            return PacketUtils.sendToServer(new PacketBatchConfiguration(this.tile.getBlockPos(), Screen.hasShiftDown() ? null : this.currentType, targetType));
        }, TooltipUtils.create(MekanismLang.SIDE_CONFIG_CLEAR, MekanismLang.SIDE_CONFIG_CLEAR_ALL), TooltipUtils.create((ILangEntry)MekanismLang.SIDE_CONFIG_INCREMENT)));
        this.addSideDataButton(RelativeSide.BOTTOM, 67, 92);
        this.addSideDataButton(RelativeSide.TOP, 67, 46);
        this.addSideDataButton(RelativeSide.FRONT, 67, 69);
        this.addSideDataButton(RelativeSide.BACK, 44, 92);
        this.addSideDataButton(RelativeSide.LEFT, 44, 69);
        this.addSideDataButton(RelativeSide.RIGHT, 90, 69);
        this.updateTabs();
        ((MekanismContainer)((GuiMekanism)this.gui()).getMenu()).startTracking(1, ((ISideConfiguration)this.tile).getConfig());
        PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CONTAINER_TRACK_SIDE_CONFIG, (BlockEntity)tile, 1));
    }

    private DataType getTargetType(BiFunction<DataType, Predicate<DataType>, DataType> shift) {
        if (Screen.hasShiftDown()) {
            return DataType.NONE;
        }
        ConfigInfo info = ((ISideConfiguration)this.tile).getConfig().getConfig(this.currentType);
        if (info != null) {
            DataType commonType = null;
            for (RelativeSide side : EnumUtils.SIDES) {
                if (!info.isSideEnabled(side)) continue;
                DataType current = info.getDataType(side);
                if (commonType == null) {
                    commonType = current;
                    continue;
                }
                if (commonType == current) continue;
                return DataType.NONE;
            }
            if (commonType != null) {
                return shift.apply(commonType, info::supports);
            }
        }
        return DataType.NONE;
    }

    private void addSideDataButton(RelativeSide side, int xPos, int yPos) {
        this.sideConfigButtons.put(side, this.addChild(new SideDataButton(this.gui(), this.relativeX + xPos, this.relativeY + yPos, side, () -> ((ISideConfiguration)this.tile).getConfig().getDataType(this.currentType, side), () -> {
            DataType dataType = ((ISideConfiguration)this.tile).getConfig().getDataType(this.currentType, side);
            return dataType == null ? EnumColor.GRAY : dataType.getColor();
        }, (TileEntityMekanism)this.tile, (pos, clickType, inputSide) -> new PacketSideData(pos, clickType, inputSide, this.currentType), true)));
    }

    @Override
    public void close() {
        super.close();
        PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CONTAINER_STOP_TRACKING, (BlockEntity)this.tile, 1));
        ((MekanismContainer)((GuiMekanism)this.gui()).getMenu()).stopTracking(1);
    }

    public void setCurrentType(TransmissionType type) {
        this.currentType = type;
    }

    @Nullable
    private ConfigInfo getCurrentConfig() {
        return ((ISideConfiguration)this.tile).getConfig().getConfig(this.currentType);
    }

    public void updateTabs() {
        for (GuiConfigTypeTab tab : this.configTabs) {
            tab.visible = this.currentType != tab.getTransmissionType();
        }
        ConfigInfo config = this.getCurrentConfig();
        if (config == null) {
            this.ejectButton.active = false;
            for (SideDataButton sideDataButton : this.sideConfigButtons.values()) {
                sideDataButton.active = false;
            }
        } else {
            this.ejectButton.active = config.canEject();
            for (Map.Entry entry : this.sideConfigButtons.entrySet()) {
                ((SideDataButton)entry.getValue()).active = config.isSideEnabled((RelativeSide)entry.getKey());
            }
        }
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        this.drawTitleText(guiGraphics, (Component)MekanismLang.CONFIG_TYPE.translate(this.currentType), 5);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.SLOTS.translate(), 0, 120, IFancyFontRenderer.TextAlignment.CENTER, this.subheadingTextColor(), 4, false);
    }

    @Override
    protected int getTitlePadEnd() {
        return super.getTitlePadEnd() + 18;
    }
}

