/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.util.function.Supplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GuiArrowSelection
extends GuiTexturedElement {
    private static final ResourceLocation ARROW = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "arrow_selection.png");
    private final Supplier<Component> targetText;

    public GuiArrowSelection(IGuiWrapper gui, int x, int y, Supplier<Component> targetText) {
        super(ARROW, gui, x, y, 33, 19);
        this.targetText = targetText;
    }

    @Override
    public boolean isMouseOver(double xAxis, double yAxis) {
        return this.active && this.visible && xAxis >= (double)(this.getX() + 16) && xAxis < (double)(this.getRight() - 1) && yAxis >= (double)(this.getY() + 1) && yAxis < (double)(this.getBottom() - 1);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        Component component = this.targetText.get();
        if (component != null) {
            this.drawScrollingString(guiGraphics, component, this.getWidth(), 6, IFancyFontRenderer.TextAlignment.LEFT, this.screenTextColor(), 15, 1, false);
        }
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.blit(this.getResource(), this.relativeX, this.relativeY, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
    }
}

