/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiUpArrow;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.button.BasicColorButton;
import mekanism.client.gui.element.button.TooltipColorButton;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.gui.element.tab.GuiVisualsTab;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.FixedUsageEnergyContainer;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.interfaces.IHasVisualization;
import mekanism.common.tile.machine.TileEntityDimensionalStabilizer;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiDimensionalStabilizer
extends GuiMekanismTile<TileEntityDimensionalStabilizer, MekanismTileContainer<TileEntityDimensionalStabilizer>> {
    private static final Component BLANK_LINE = CommonComponents.SPACE;

    public GuiDimensionalStabilizer(MekanismTileContainer<TileEntityDimensionalStabilizer> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.inventoryLabelY += 2;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityDimensionalStabilizer)this.tile).getEnergyContainer(), 164, 15)).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY, () -> {
            FixedUsageEnergyContainer<TileEntityDimensionalStabilizer> energyContainer = ((TileEntityDimensionalStabilizer)this.tile).getEnergyContainer();
            return energyContainer.getEnergyPerTick() > energyContainer.getEnergy();
        });
        this.addRenderableWidget(new GuiVisualsTab(this, (IHasVisualization)((Object)this.tile)));
        this.addRenderableWidget(new GuiEnergyTab((IGuiWrapper)this, ((TileEntityDimensionalStabilizer)this.tile).getEnergyContainer(), ((TileEntityDimensionalStabilizer)this.tile)::getActive));
        int tileChunkX = SectionPos.blockToSectionCoord((int)((TileEntityDimensionalStabilizer)this.tile).getBlockPos().getX());
        int tileChunkZ = SectionPos.blockToSectionCoord((int)((TileEntityDimensionalStabilizer)this.tile).getBlockPos().getZ());
        for (int x = -2; x <= 2; ++x) {
            int shiftedX = x + 2;
            final int chunkX = tileChunkX + x;
            for (int z = -2; z <= 2; ++z) {
                int shiftedZ = z + 2;
                final int chunkZ = tileChunkZ + z;
                if (x == 0 && z == 0) {
                    this.addRenderableWidget(new BasicColorButton(this, 63 + 10 * shiftedX, 19 + 10 * shiftedZ, 10, () -> EnumColor.DARK_BLUE, (element, mouseX, mouseY) -> {
                        for (int i = 1; i <= 2; ++i) {
                            if (!this.hasAtRadius(i, false)) continue;
                            return PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.ENABLE_RADIUS_CHUNKLOAD, (BlockEntity)this.tile, i));
                        }
                        return false;
                    }, (element, mouseX, mouseY) -> {
                        for (int i = 2; i > 0; --i) {
                            if (!this.hasAtRadius(i, true)) continue;
                            return PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.DISABLE_RADIUS_CHUNKLOAD, (BlockEntity)this.tile, i));
                        }
                        return false;
                    }){
                        private List<Component> lastInfo;
                        @Nullable
                        private Tooltip lastTooltip;
                        {
                            super(gui, x, y, size, color, onLeftClick, onRightClick);
                            this.lastInfo = Collections.emptyList();
                        }

                        @Override
                        public void updateTooltip(int mouseX, int mouseY) {
                            int i;
                            ArrayList<Component> tooltips = new ArrayList<Component>();
                            tooltips.add((Component)MekanismLang.STABILIZER_CENTER.translate(EnumColor.INDIGO, chunkX, EnumColor.INDIGO, chunkZ));
                            for (i = 1; i <= 2; ++i) {
                                if (!GuiDimensionalStabilizer.this.hasAtRadius(i, false)) continue;
                                tooltips.add(BLANK_LINE);
                                tooltips.add((Component)MekanismLang.STABILIZER_ENABLE_RADIUS.translate(EnumColor.INDIGO, i, EnumColor.INDIGO, chunkX, EnumColor.INDIGO, chunkZ));
                                break;
                            }
                            for (i = 2; i > 0; --i) {
                                if (!GuiDimensionalStabilizer.this.hasAtRadius(i, true)) continue;
                                tooltips.add(BLANK_LINE);
                                tooltips.add((Component)MekanismLang.STABILIZER_DISABLE_RADIUS.translate(EnumColor.INDIGO, i, EnumColor.INDIGO, chunkX, EnumColor.INDIGO, chunkZ));
                                break;
                            }
                            if (!tooltips.equals(this.lastInfo)) {
                                this.lastInfo = tooltips;
                                this.lastTooltip = TooltipUtils.create(tooltips);
                            }
                            this.setTooltip(this.lastTooltip);
                        }
                    });
                    continue;
                }
                int packetTarget = shiftedX * 5 + shiftedZ;
                this.addRenderableWidget(new TooltipColorButton(this, 63 + 10 * shiftedX, 19 + 10 * shiftedZ, 10, EnumColor.DARK_BLUE, () -> ((TileEntityDimensionalStabilizer)this.tile).isChunkLoadingAt(shiftedX, shiftedZ), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.TOGGLE_CHUNKLOAD, (BlockEntity)this.tile, packetTarget)), (Component)MekanismLang.STABILIZER_TOGGLE_LOADING.translate(BooleanStateDisplay.OnOff.ON_COLORED, EnumColor.INDIGO, chunkX, EnumColor.INDIGO, chunkZ), (Component)MekanismLang.STABILIZER_TOGGLE_LOADING.translate(BooleanStateDisplay.OnOff.OFF_COLORED, EnumColor.INDIGO, chunkX, EnumColor.INDIGO, chunkZ)));
            }
        }
        this.addRenderableWidget(new GuiUpArrow(this, 52, 28));
    }

    private boolean hasAtRadius(int radius, boolean state) {
        for (int x = -radius; x <= radius; ++x) {
            boolean skipInner = x > -radius && x < radius;
            int actualX = x + 2;
            for (int z = -radius; z <= radius; z += skipInner ? 2 * radius : 1) {
                if (((TileEntityDimensionalStabilizer)this.tile).isChunkLoadingAt(actualX, z + 2) != state) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.renderInventoryText(guiGraphics);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.NORTH_SHORT.translate(), 49, 41, IFancyFontRenderer.TextAlignment.CENTER, this.titleTextColor(), 15, 2, false);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

