/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.security;

import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.security.IOwnerObject;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.ISecurityUtils;
import mekanism.api.security.SecurityMode;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface ITypedSecurityUtils<PROVIDER> {
    @Nullable
    @Contract(value="null -> null")
    public IOwnerObject ownerCapability(@Nullable PROVIDER var1);

    @Nullable
    @Contract(value="null -> null")
    public ISecurityObject securityCapability(@Nullable PROVIDER var1);

    @Contract(value="_, null -> true")
    default public boolean canAccess(Player player, @Nullable PROVIDER provider) {
        if (provider == null) {
            return true;
        }
        return ISecurityUtils.INSTANCE.canAccess(player, provider, this::securityCapability, this::ownerCapability);
    }

    @Contract(value="_, null, _ -> true")
    default public boolean canAccess(@Nullable UUID player, @Nullable PROVIDER provider, boolean isClient) {
        if (provider == null) {
            return true;
        }
        return ISecurityUtils.INSTANCE.canAccess(player, provider, this::securityCapability, this::ownerCapability, isClient);
    }

    @Nullable
    @Contract(value="null -> null")
    default public UUID getOwnerUUID(@Nullable PROVIDER provider) {
        if (provider == null) {
            return null;
        }
        IOwnerObject ownerObject = this.ownerCapability(provider);
        return ownerObject == null ? null : ownerObject.getOwnerUUID();
    }

    default public SecurityMode getSecurityMode(@Nullable PROVIDER provider, boolean isClient) {
        if (provider == null) {
            return SecurityMode.PUBLIC;
        }
        return ISecurityUtils.INSTANCE.getSecurityMode(provider, this::securityCapability, this::ownerCapability, isClient);
    }

    @Contract(value="_, null -> true")
    default public boolean canAccessOrDisplayError(Player player, @Nullable PROVIDER provider) {
        if (this.canAccess(player, provider)) {
            return true;
        }
        if (!player.level().isClientSide) {
            ISecurityUtils.INSTANCE.displayNoAccess(player);
        }
        return false;
    }
}

