/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.config.ModuleConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ModuleEnumConfig<TYPE extends Enum<TYPE>>
extends ModuleConfig<TYPE> {
    private final List<TYPE> enumConstants;
    private final TYPE value;

    public static <TYPE extends Enum<TYPE>> Codec<ModuleEnumConfig<TYPE>> codec(Codec<TYPE> enumCodec) {
        return RecordCodecBuilder.create(instance -> ModuleEnumConfig.baseCodec(instance).and((App)enumCodec.fieldOf("value").forGetter(ModuleConfig::get)).apply((Applicative)instance, (x$0, x$1) -> new ModuleEnumConfig<Enum>((ResourceLocation)x$0, (Enum)x$1)));
    }

    public static <TYPE extends Enum<TYPE>> Codec<ModuleEnumConfig<TYPE>> codec(Codec<TYPE> enumCodec, Class<TYPE> enumClass, int selectableCount) {
        if (selectableCount <= 0) {
            throw new IllegalArgumentException("Invalid selectableCount, there must be at least one element that is selectable.");
        }
        List enumConstants = ModuleEnumConfig.getEnumConstants(enumClass, selectableCount);
        if (enumConstants == null) {
            return ModuleEnumConfig.codec(enumCodec);
        }
        return RecordCodecBuilder.create(instance -> ModuleEnumConfig.baseCodec(instance).and((App)enumCodec.validate(value -> value.ordinal() < selectableCount ? DataResult.success((Object)value) : DataResult.error(() -> "Invalid value" + value.name() + ", it is out of range of the selectable values.")).fieldOf("value").forGetter(ModuleConfig::get)).apply((Applicative)instance, (name, value) -> new ModuleEnumConfig<Enum>((ResourceLocation)name, (Enum)value, enumConstants)));
    }

    public static <BUF extends ByteBuf, TYPE extends Enum<TYPE>> StreamCodec<BUF, ModuleEnumConfig<TYPE>> streamCodec(StreamCodec<BUF, TYPE> enumCodec) {
        return StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ModuleConfig::name, enumCodec, ModuleConfig::get, (x$0, x$1) -> new ModuleEnumConfig<Enum>((ResourceLocation)x$0, (Enum)x$1));
    }

    public static <BUF extends ByteBuf, TYPE extends Enum<TYPE>> StreamCodec<BUF, ModuleEnumConfig<TYPE>> streamCodec(StreamCodec<BUF, TYPE> enumCodec, Class<TYPE> enumClass, int selectableCount) {
        if (selectableCount <= 0) {
            throw new IllegalArgumentException("Invalid selectableCount, there must be at least one element that is selectable.");
        }
        List enumConstants = ModuleEnumConfig.getEnumConstants(enumClass, selectableCount);
        if (enumConstants == null) {
            return ModuleEnumConfig.streamCodec(enumCodec);
        }
        return StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ModuleConfig::name, enumCodec, ModuleConfig::get, (name, value) -> new ModuleEnumConfig<Enum>((ResourceLocation)name, (Enum)value, enumConstants));
    }

    public static <TYPE extends Enum<TYPE>> ModuleEnumConfig<TYPE> create(ResourceLocation name, TYPE value) {
        return new ModuleEnumConfig<TYPE>(name, value);
    }

    public static <TYPE extends Enum<TYPE>> ModuleEnumConfig<TYPE> createBounded(ResourceLocation name, TYPE value, int selectableCount) {
        if (selectableCount <= 0) {
            throw new IllegalArgumentException("Invalid selectableCount, there must be at least one element that is selectable.");
        }
        if (value.ordinal() >= selectableCount) {
            throw new IllegalArgumentException("Invalid value, it is out of range of the selectable values.");
        }
        Class<TYPE> enumClass = value.getDeclaringClass();
        List<TYPE> enumConstants = ModuleEnumConfig.getEnumConstants(enumClass, selectableCount);
        if (enumConstants == null) {
            return ModuleEnumConfig.create(name, value);
        }
        return new ModuleEnumConfig<TYPE>(name, value, enumConstants);
    }

    @Nullable
    private static <TYPE extends Enum<TYPE>> List<TYPE> getEnumConstants(Class<TYPE> enumClass, int selectableCount) {
        Enum[] constants = (Enum[])enumClass.getEnumConstants();
        if (constants.length < selectableCount) {
            throw new IllegalArgumentException("Selectable count is larger than the number of elements in " + enumClass.getSimpleName());
        }
        if (constants.length == selectableCount) {
            return null;
        }
        return List.of(constants).subList(0, selectableCount);
    }

    private ModuleEnumConfig(ResourceLocation name, TYPE value) {
        this(name, (Enum)value, List.of((Enum[])((Enum)value).getDeclaringClass().getEnumConstants()));
    }

    private ModuleEnumConfig(ResourceLocation name, TYPE value, List<TYPE> enumConstants) {
        super(name);
        this.value = value;
        this.enumConstants = enumConstants;
    }

    @Override
    public StreamCodec<FriendlyByteBuf, ModuleConfig<TYPE>> namedStreamCodec(ResourceLocation name) {
        return NeoForgeStreamCodecs.enumCodec(((Enum)this.value).getDeclaringClass()).map(value -> new ModuleEnumConfig<Enum>(name, (Enum)value, (List<Enum>)this.enumConstants), ModuleConfig::get);
    }

    @Override
    public TYPE get() {
        return this.value;
    }

    public List<TYPE> getEnumConstants() {
        return this.enumConstants;
    }

    @Override
    public ModuleEnumConfig<TYPE> with(TYPE value) {
        Objects.requireNonNull(value, "Value cannot be null.");
        if (((Enum)value).ordinal() >= this.enumConstants.size()) {
            throw new IllegalArgumentException("Invalid value, it is out of range of the selectable values.");
        }
        if (this.value == value) {
            return this;
        }
        return new ModuleEnumConfig<TYPE>(this.name(), value);
    }

    @Override
    public ModuleEnumConfig<TYPE> with(int index) {
        if (index < 0 || index >= this.enumConstants.size()) {
            throw new IllegalArgumentException("Invalid value, it is out of range of the selectable values.");
        }
        if (((Enum)this.value).ordinal() == index) {
            return this;
        }
        return new ModuleEnumConfig<Enum>(this.name(), (Enum)this.enumConstants.get(index));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModuleEnumConfig other = (ModuleEnumConfig)o;
        return this.value == other.value && this.enumConstants.size() == other.enumConstants.size();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ((Enum)this.value).hashCode();
        result = 31 * result + Integer.hashCode(this.enumConstants.size());
        return result;
    }
}

