/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datamaps.chemical.attribute;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttributes;
import mekanism.api.datamaps.chemical.attribute.IChemicalCoolant;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public record CooledCoolant(Holder<Chemical> otherVariant, double thermalEnthalpy, double conductivity) implements IChemicalCoolant
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"chemical_attribute_cooled_coolant");
    public static final Codec<CooledCoolant> CODEC = RecordCodecBuilder.create(instance -> IChemicalCoolant.createBaseCodec(instance, "hot_variant", 1.0).apply((Applicative)instance, CooledCoolant::new));

    public CooledCoolant {
        IChemicalCoolant.validateCoolantParams(otherVariant, thermalEnthalpy, conductivity);
    }

    public ChemicalStack heat(long amountHeated) {
        return new ChemicalStack(this.otherVariant, amountHeated);
    }

    @Override
    @ApiStatus.Internal
    public ChemicalAttributes.CooledCoolant toLegacyAttribute() {
        return new ChemicalAttributes.CooledCoolant(this);
    }
}

