/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.util;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.commands.IEnumCommand;
import net.darkhax.bookshelf.common.api.commands.PermissionLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.world.entity.Entity;

public class CommandHelper {
    public static <T extends Enum<T>> LiteralArgumentBuilder<CommandSourceStack> buildFromEnum(String parent, Class<T> enumClass) {
        LiteralArgumentBuilder parentNode = LiteralArgumentBuilder.literal((String)parent);
        parentNode.requires((Predicate)CommandHelper.getLowestLevel(enumClass));
        CommandHelper.buildFromEnum(parentNode, enumClass);
        return parentNode;
    }

    public static <T extends Enum<T>> void buildFromEnum(ArgumentBuilder<CommandSourceStack, ?> parent, Class<T> enumClass) {
        if (!enumClass.isEnum()) {
            throw new IllegalStateException("Class '" + enumClass.getCanonicalName() + "' is not an enum!");
        }
        for (Enum enumEntry : (Enum[])enumClass.getEnumConstants()) {
            LiteralArgumentBuilder literal = LiteralArgumentBuilder.literal((String)((IEnumCommand)((Object)enumEntry)).getCommandName());
            ((LiteralArgumentBuilder)literal.requires((Predicate)((IEnumCommand)((Object)enumEntry)).requiredPermissionLevel())).executes((Command)enumEntry);
            parent.then((ArgumentBuilder)literal);
        }
    }

    public static <T extends Enum<T>> PermissionLevel getLowestLevel(Class<T> enumClass) {
        if (!enumClass.isEnum()) {
            throw new IllegalStateException("Class '" + enumClass.getCanonicalName() + "' is not an enum!");
        }
        PermissionLevel level = PermissionLevel.OWNER;
        for (Enum enumEntry : (Enum[])enumClass.getEnumConstants()) {
            if (((IEnumCommand)((Object)enumEntry)).requiredPermissionLevel().get() >= level.get()) continue;
            level = ((IEnumCommand)((Object)enumEntry)).requiredPermissionLevel();
        }
        return level;
    }

    @Deprecated
    public static <T> boolean hasArgument(String argument, CommandContext<T> context) {
        return CommandHelper.hasArgument(argument, context, Object.class);
    }

    public static <T, C> boolean hasArgument(String argument, CommandContext<C> context, Class<T> argType) {
        try {
            return context.getArgument(argument, argType) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T, C> T getArgument(String argument, CommandContext<C> context, Class<T> argType, Supplier<T> fallback) {
        return (T)(CommandHelper.hasArgument(argument, context, argType) ? context.getArgument(argument, argType) : fallback.get());
    }

    public static Entity getEntity(String argName, CommandContext<CommandSourceStack> ctx, Supplier<Entity> fallback) throws CommandSyntaxException {
        return CommandHelper.hasArgument(argName, ctx, EntitySelector.class) ? EntityArgument.getEntity(ctx, (String)argName) : fallback.get();
    }

    public static Entity getEntityOrSender(String argName, CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return CommandHelper.hasArgument(argName, ctx, EntitySelector.class) ? EntityArgument.getEntity(ctx, (String)argName) : ((CommandSourceStack)ctx.getSource()).getEntity();
    }

    public static boolean getBooleanArg(String argName, CommandContext<CommandSourceStack> ctx, Supplier<Boolean> fallback) {
        return CommandHelper.hasArgument(argName, ctx, Boolean.class) ? BoolArgumentType.getBool(ctx, (String)argName) : fallback.get();
    }

    public static boolean getBooleanArg(String argName, CommandContext<CommandSourceStack> ctx) {
        return CommandHelper.getBooleanArg(argName, ctx, () -> false);
    }
}

