/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.registry.adapters;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.registry.RegistrationContext;
import net.darkhax.bookshelf.common.api.registry.RegistryReference;
import net.darkhax.bookshelf.common.api.registry.adapters.RegistryAdapter;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class GameRegistryAdapter<V>
implements RegistryAdapter<ResourceKey<V>, V> {
    protected final RegistrationContext context;
    protected final ResourceKey<Registry<V>> registryKey;
    protected final BiConsumer<ResourceKey<V>, Supplier<V>> registryFunc;

    public GameRegistryAdapter(RegistrationContext context, ResourceKey<Registry<V>> registryKey, BiConsumer<ResourceKey<V>, Supplier<V>> registryFunc) {
        this.context = context;
        this.registryKey = registryKey;
        this.registryFunc = registryFunc;
    }

    @Override
    public RegistryReference<ResourceKey<V>, V> add(String key, Supplier<V> value) {
        ResourceKey resourceKey = ResourceKey.create(this.registryKey, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.context.namespace(), (String)key));
        this.registryFunc.accept(resourceKey, value);
        return RegistryReference.resource(resourceKey);
    }

    public final ResourceLocation id(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)this.context.namespace(), (String)key);
    }
}

