/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.tag;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.FloatingRectangle;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.client.categories.tag.TagTreeWidget;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.tag.DefaultTagDisplay;
import me.shedaniel.rei.plugin.common.displays.tag.TagNode;
import me.shedaniel.rei.plugin.common.displays.tag.TagNodes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class DefaultTagCategory
implements DisplayCategory<DefaultTagDisplay<?, ?>> {
    @Override
    public CategoryIdentifier<? extends DefaultTagDisplay<?, ?>> getCategoryIdentifier() {
        return BuiltinPlugin.TAG;
    }

    @Override
    public Component getTitle() {
        return Component.translatable((String)"category.rei.tag");
    }

    @Override
    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)Items.NAME_TAG);
    }

    @Override
    public List<Widget> setupDisplay(DefaultTagDisplay<?, ?> display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        Window window = Minecraft.getInstance().getWindow();
        Rectangle boundsBig = new Rectangle((double)window.getGuiScaledWidth() * 0.05, (double)window.getGuiScaledHeight() * 0.1, (double)window.getGuiScaledWidth() * 0.9, (double)window.getGuiScaledHeight() * 0.8);
        final Rectangle recipeBounds = bounds.clone();
        final boolean[] expanded = new boolean[]{false};
        Rectangle innerBounds = new Rectangle(bounds.x + 6 + 14, bounds.y + 6, bounds.width - 12 - 14, bounds.height - 12);
        Rectangle overflowBounds = new Rectangle(innerBounds.x + 1, innerBounds.y + 1, innerBounds.width - 2, innerBounds.height - 2);
        Rectangle expandButtonBounds = new Rectangle(bounds.x + 5, bounds.y + 6, 13, 13);
        Rectangle expandOverlayBounds = new Rectangle(bounds.x + 5 + 2, bounds.y + 6 + 2, 9, 9);
        Rectangle copyButtonBounds = new Rectangle(bounds.x + 5, bounds.getMaxY() - 6 - 13, 13, 13);
        Rectangle copyOverlayBounds = new Rectangle(bounds.x + 5 + 2, bounds.getMaxY() - 6 - 13 + 2, 9, 9);
        ValueAnimator boundsAnimator = ValueAnimator.ofFloatingRectangle((FloatingRectangle)bounds.getFloatingBounds()).withConvention(() -> {
            if (expanded[0]) {
                return boundsBig.getFloatingBounds();
            }
            return bounds.getFloatingBounds();
        }, 1400L);
        widgets.add(Widgets.createDrawableWidget((matrices, mouseX, mouseY, delta) -> {
            innerBounds.setBounds(recipeBounds.x + 6 + 14, recipeBounds.y + 6, recipeBounds.width - 12 - 14, recipeBounds.height - 12);
            overflowBounds.setBounds(innerBounds.x + 1, innerBounds.y + 1, innerBounds.width - 2, innerBounds.height - 2);
            expandButtonBounds.setBounds(recipeBounds.x + 5, recipeBounds.y + 6, 13, 13);
            copyButtonBounds.setBounds(recipeBounds.x + 5, recipeBounds.getMaxY() - 6 - 13, 13, 13);
            expandOverlayBounds.setBounds(recipeBounds.x + 5 + 2, recipeBounds.y + 6 + 2, 9, 9);
            copyOverlayBounds.setBounds(recipeBounds.x + 5 + 2, recipeBounds.getMaxY() - 6 - 13 + 2, 9, 9);
            recipeBounds.setBounds((FloatingRectangle)boundsAnimator.value());
            boundsAnimator.update((double)delta);
            if (overflowBounds.contains(mouseX, mouseY)) {
                REIRuntime.getInstance().clearTooltips();
            }
        }));
        widgets.add(Widgets.createRecipeBase(recipeBounds));
        widgets.add(Widgets.createSlotBase(innerBounds));
        WidgetWithBounds[] delegate = new WidgetWithBounds[]{Widgets.noOp()};
        TagNode[] tagNode = new TagNode[]{null};
        widgets.add(Widgets.withTranslate(Widgets.delegateWithBounds(() -> delegate[0]), 0.0, 0.0, 20.0));
        TagNodes.create(display.getKey(), dataResult -> {
            if (dataResult.error().isPresent()) {
                delegate[0] = Widgets.withBounds(Widgets.concat(Widgets.createLabel(new Point(innerBounds.getCenterX(), innerBounds.getCenterY() - 8), (Component)Component.literal((String)"Failed to resolve tags!")), Widgets.createLabel(new Point(innerBounds.getCenterX(), innerBounds.getCenterY() + 1), (Component)Component.literal((String)((DataResult.Error)dataResult.error().get()).message()))), overflowBounds);
            } else {
                tagNode[0] = (TagNode)dataResult.result().get();
                Function displayMapper = display.getMapper();
                Function mapper = holder -> {
                    EntryStack stack = (EntryStack)displayMapper.apply(holder);
                    if (stack.isEmpty()) {
                        return ClientEntryStacks.of(new Renderer(){
                            final /* synthetic */ Holder val$holder;
                            {
                                this.val$holder = holder;
                            }

                            @Override
                            public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                                Minecraft instance = Minecraft.getInstance();
                                Font font = instance.font;
                                String text = "?";
                                int width = font.width(text);
                                graphics.pose().pushPose();
                                PoseStack poseStack = graphics.pose();
                                float f = (float)bounds.getCenterX() - (float)width / 2.0f + 0.2f;
                                float f2 = bounds.getCenterY();
                                Objects.requireNonNull(font);
                                poseStack.translate(f, f2 - 9.0f / 2.0f + 1.0f, 0.0f);
                                graphics.drawString(font, text, 0, 0, REIRuntime.getInstance().isDarkThemeEnabled() ? -4473925 : -12566464, false);
                                graphics.pose().popPose();
                            }

                            @Override
                            @Nullable
                            public Tooltip getTooltip(TooltipContext context) {
                                return Tooltip.create(context.getPoint(), new Component[]{Component.literal((String)this.val$holder.unwrapKey().map(key -> key.location().toString()).orElse("null"))});
                            }
                        });
                    }
                    return stack;
                };
                delegate[0] = Widgets.overflowed(overflowBounds, Widgets.padded(16, new TagTreeWidget(tagNode[0], mapper, overflowBounds)));
            }
        });
        widgets.add(Widgets.createButton(expandButtonBounds, (Component)Component.literal((String)"")).onRender((poseStack, button) -> button.setEnabled(tagNode[0] != null)).onClick(button -> {
            expanded[0] = !expanded[0];
        }).tooltipSupplier(button -> new Component[]{Component.translatable((String)(!expanded[0] ? "text.rei.expand.view" : "text.rei.expand.view.close"))}));
        widgets.add(Widgets.createButton(copyButtonBounds, (Component)Component.literal((String)"")).onRender((poseStack, button) -> button.setEnabled(tagNode[0] != null)).onClick(button -> {
            TagNode node = tagNode[0];
            if (node != null) {
                Minecraft.getInstance().keyboardHandler.setClipboard(node.asTree());
            }
        }).tooltipLine((Component)Component.translatable((String)"text.rei.tag.copy.clipboard")));
        widgets.add(Widgets.withTranslate(new DelegateWidget(this, Widgets.noOp()){

            @Override
            protected Widget delegate() {
                ResourceLocation expandTexture = !expanded[0] ? ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"textures/gui/expand.png") : ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"textures/gui/shrink.png");
                return Widgets.concat(Widgets.createTexturedWidget(expandTexture, new Rectangle(recipeBounds.x + 5 + 2, recipeBounds.y + 6 + 2, 9, 9), 0.0f, 0.0f, 9, 9), Widgets.createTexturedWidget(ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"textures/gui/clipboard.png"), new Rectangle(recipeBounds.x + 5 + 2, recipeBounds.getMaxY() - 6 - 13 + 2, 9, 9), 0.0f, 0.0f, 9, 9));
            }
        }, 0.0, 0.0, 10.0));
        Matrix4f translateMatrix = new Matrix4f().translate(0.0f, 0.0f, 200.0f);
        Matrix4f identity = new Matrix4f();
        identity.identity();
        return CollectionUtils.map(widgets, widget -> Widgets.withTranslate(widget, () -> expanded[0] || !((FloatingRectangle)boundsAnimator.value()).equals(boundsAnimator.target()) ? translateMatrix : identity));
    }
}

