/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.autocrafting.recipebook;

import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultCookingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultRecipeBookHandler
implements TransferHandler {
    @Override
    public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
        if (context.getDisplay() instanceof SimpleGridMenuDisplay && ClientHelper.getInstance().canUseMovePackets()) {
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }
        Display display = context.getDisplay();
        AbstractContainerMenu abstractContainerMenu = context.getMenu();
        if (!(abstractContainerMenu instanceof RecipeBookMenu)) {
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }
        RecipeBookMenu container = (RecipeBookMenu)abstractContainerMenu;
        if (container == null) {
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }
        return TransferHandler.ApplicabilityResult.createApplicable();
    }

    @Override
    public TransferHandler.Result handle(TransferHandler.Context context) {
        DefaultCookingDisplay defaultDisplay;
        RecipeBookMenu container = (RecipeBookMenu)context.getMenu();
        Display display = context.getDisplay();
        if (display instanceof DefaultCraftingDisplay) {
            DefaultCraftingDisplay craftingDisplay = (DefaultCraftingDisplay)display;
            if (craftingDisplay.getOptionalRecipe().isPresent()) {
                int h = -1;
                int w = -1;
                if (container instanceof CraftingMenu) {
                    h = 3;
                    w = 3;
                } else if (container instanceof InventoryMenu) {
                    h = 2;
                    w = 2;
                }
                if (h == -1 || w == -1) {
                    return TransferHandler.Result.createNotApplicable();
                }
                RecipeHolder recipe = craftingDisplay.getOptionalRecipe().get();
                if (craftingDisplay.getHeight() > h || craftingDisplay.getWidth() > w) {
                    return TransferHandler.Result.createFailed((Component)Component.translatable((String)"error.rei.transfer.too_small", (Object[])new Object[]{h, w}));
                }
                if (!context.getMinecraft().player.getRecipeBook().contains(recipe)) {
                    return TransferHandler.Result.createNotApplicable();
                }
                if (!context.isActuallyCrafting()) {
                    return TransferHandler.Result.createSuccessful();
                }
                context.getMinecraft().setScreen(context.getContainerScreen());
                if (context.getContainerScreen() instanceof RecipeUpdateListener) {
                    ((RecipeUpdateListener)context.getContainerScreen()).getRecipeBookComponent().ghostRecipe.clear();
                }
                context.getMinecraft().gameMode.handlePlaceRecipe(container.containerId, recipe, context.isStackedCrafting());
                return TransferHandler.Result.createSuccessful();
            }
        } else if (display instanceof DefaultCookingDisplay && (defaultDisplay = (DefaultCookingDisplay)display).getOptionalRecipe().isPresent()) {
            RecipeHolder<?> recipe = defaultDisplay.getOptionalRecipe().get();
            if (!context.getMinecraft().player.getRecipeBook().contains(recipe)) {
                return TransferHandler.Result.createNotApplicable();
            }
            if (!context.isActuallyCrafting()) {
                return TransferHandler.Result.createSuccessful();
            }
            context.getMinecraft().setScreen(context.getContainerScreen());
            if (context.getContainerScreen() instanceof RecipeUpdateListener) {
                ((RecipeUpdateListener)context.getContainerScreen()).getRecipeBookComponent().ghostRecipe.clear();
            }
            context.getMinecraft().gameMode.handlePlaceRecipe(container.containerId, recipe, context.isStackedCrafting());
            return TransferHandler.Result.createSuccessful();
        }
        return TransferHandler.Result.createNotApplicable();
    }

    @Override
    public double getPriority() {
        return -20.0;
    }
}

