/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.util;

import java.util.Comparator;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;

public class RectangleUtils {
    public static Rectangle inset(Rectangle rectangle, int inset) {
        return RectangleUtils.inset(rectangle, inset, inset);
    }

    public static Rectangle inset(Rectangle rectangle, int insetX, int insetY) {
        return RectangleUtils.inset(rectangle, insetX, insetY, insetX, insetY);
    }

    public static Rectangle inset(Rectangle rectangle, int insetLeft, int insetTop, int insetRight, int insetBottom) {
        return new Rectangle(rectangle.x + insetLeft, rectangle.y + insetTop, rectangle.width - insetLeft - insetRight, rectangle.height - insetTop - insetBottom);
    }

    public static Rectangle excludeZones(Rectangle rectangle, Stream<Rectangle> exclusionZones) {
        return exclusionZones.filter(rect -> rect.intersects(rectangle)).sorted(Comparator.comparingInt(rect -> rect.width * rect.height)).reduce(rectangle, (rect1, rect2) -> {
            int cutLeft = rect2.getMaxX() - rect1.x;
            int cutRight = rect1.getMaxX() - rect2.x;
            int cutTop = rect2.getMaxY() - rect1.y;
            int cutBottom = rect1.getMaxY() - rect2.y;
            return Stream.of(new Rectangle(rect1.x + cutLeft, rect1.y, rect1.width - cutLeft, rect1.height), new Rectangle(rect1.x, rect1.y, rect1.width - cutRight, rect1.height), new Rectangle(rect1.x, rect1.y + cutTop, rect1.width, rect1.height - cutTop), new Rectangle(rect1.x, rect1.y, rect1.width, rect1.height - cutBottom)).filter(rect -> rect.width > 0 && rect.height > 0).max(Comparator.comparingInt(rect -> rect.width * rect.height)).orElse(new Rectangle());
        });
    }
}

