/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.method.unihan;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import dev.architectury.platform.Platform;
import dev.architectury.utils.value.BooleanValue;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.impl.client.search.method.unihan.PinyinInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.UniHanManager;
import net.minecraft.network.chat.Component;

public class DoublePinyinInputMethod
extends PinyinInputMethod {
    private Converter converter = Converters.SOUGOU;

    public DoublePinyinInputMethod(UniHanManager manager) {
        super(manager);
    }

    @Override
    protected void read() {
        Path path = Platform.getConfigFolder().resolve("roughlyenoughitems/pinyin_double.properties");
        this.converter = Converters.SOUGOU;
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Properties properties = new Properties();
                try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                    properties.load(stream);
                }
                this.converter = (Converter)Converters.CONVERTERS.getOrDefault((Object)Objects.toString(properties.getOrDefault((Object)"Converter", "sougou")), (Object)Converters.SOUGOU);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        this.write();
    }

    @Override
    protected void write() {
        Path path = Platform.getConfigFolder().resolve("roughlyenoughitems/pinyin_double.properties");
        Properties properties = new Properties();
        properties.put("Converter", Converters.CONVERTERS.inverse().get((Object)this.converter));
        try (OutputStream stream = Files.newOutputStream(path, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            properties.store(stream, "Double Pinyin Options");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"text.rei.input.methods.pinyin.double");
    }

    @Override
    public Component getDescription() {
        return Component.translatable((String)"text.rei.input.methods.pinyin.double.description");
    }

    @Override
    public List<FavoriteMenuEntry> getOptionsMenuEntries() {
        ArrayList<FavoriteMenuEntry> innerEntries = new ArrayList<FavoriteMenuEntry>();
        for (final Map.Entry entry : Converters.CONVERTERS.entrySet()) {
            innerEntries.add(FavoriteMenuEntry.createToggle((Component)Component.translatable((String)("text.rei.input.methods.pinyin.double.scheme." + (String)entry.getKey())), new BooleanValue(){

                public void accept(boolean t) {
                    DoublePinyinInputMethod.this.converter = (Converter)entry.getValue();
                    DoublePinyinInputMethod.this.write();
                    DoublePinyinInputMethod.this.dataMap.clear();
                    DoublePinyinInputMethod.this.load();
                }

                public boolean getAsBoolean() {
                    return DoublePinyinInputMethod.this.converter == entry.getValue();
                }
            }));
        }
        return List.of(FavoriteMenuEntry.createSubMenu((Component)Component.translatable((String)"text.rei.input.methods.pinyin.double.scheme"), innerEntries));
    }

    @Override
    protected List<IntList> expendSimple(String string) {
        return List.of(this.converter.convert(string));
    }

    @Override
    protected List<IntList>[] expendSingles(List<IntList> codepoint) {
        if (this.converter == Converters.SOUGOU || this.converter == Converters.MICROSOFT) {
            return new List[]{List.of(IntList.of((int)111)), codepoint};
        }
        return new List[]{codepoint, codepoint};
    }

    public static interface Converters {
        public static final Converter SOUGOU = new MapConverter("iu", Character.valueOf('q'), "ia", Character.valueOf('w'), "ua", Character.valueOf('w'), "er", Character.valueOf('r'), "uan", Character.valueOf('r'), "ue", Character.valueOf('t'), "ve", Character.valueOf('t'), "uai", Character.valueOf('y'), "v", Character.valueOf('y'), "sh", Character.valueOf('u'), "ch", Character.valueOf('i'), "uo", Character.valueOf('o'), "un", Character.valueOf('p'), "ong", Character.valueOf('s'), "iong", Character.valueOf('s'), "uang", Character.valueOf('d'), "iang", Character.valueOf('d'), "en", Character.valueOf('f'), "eng", Character.valueOf('g'), "ang", Character.valueOf('h'), "an", Character.valueOf('j'), "ao", Character.valueOf('k'), "ai", Character.valueOf('l'), "ing", Character.valueOf(';'), "ei", Character.valueOf('z'), "ie", Character.valueOf('x'), "iao", Character.valueOf('c'), "zh", Character.valueOf('v'), "ui", Character.valueOf('v'), "ou", Character.valueOf('b'), "in", Character.valueOf('n'), "ian", Character.valueOf('m'));
        public static final Converter MICROSOFT = new MapConverter("iu", Character.valueOf('q'), "ia", Character.valueOf('w'), "ua", Character.valueOf('w'), "er", Character.valueOf('r'), "uan", Character.valueOf('r'), "ue", Character.valueOf('t'), "uai", Character.valueOf('y'), "v", Character.valueOf('y'), "sh", Character.valueOf('u'), "ch", Character.valueOf('i'), "uo", Character.valueOf('o'), "un", Character.valueOf('p'), "ong", Character.valueOf('s'), "iong", Character.valueOf('s'), "uang", Character.valueOf('d'), "iang", Character.valueOf('d'), "en", Character.valueOf('f'), "eng", Character.valueOf('g'), "ang", Character.valueOf('h'), "an", Character.valueOf('j'), "ao", Character.valueOf('k'), "ai", Character.valueOf('l'), "ing", Character.valueOf(';'), "ei", Character.valueOf('z'), "ie", Character.valueOf('x'), "iao", Character.valueOf('c'), "zh", Character.valueOf('v'), "ui", Character.valueOf('v'), "ve", Character.valueOf('v'), "ou", Character.valueOf('b'), "in", Character.valueOf('n'), "ian", Character.valueOf('m'));
        public static final Converter PINYINPP = new MapConverter("er", Character.valueOf('q'), "ing", Character.valueOf('q'), "ei", Character.valueOf('w'), "en", Character.valueOf('r'), "eng", Character.valueOf('t'), "iong", Character.valueOf('y'), "ong", Character.valueOf('y'), "ch", Character.valueOf('u'), "sh", Character.valueOf('i'), "uo", Character.valueOf('o'), "ou", Character.valueOf('p'), "ai", Character.valueOf('s'), "ao", Character.valueOf('d'), "an", Character.valueOf('f'), "ang", Character.valueOf('g'), "iang", Character.valueOf('h'), "uang", Character.valueOf('h'), "ian", Character.valueOf('j'), "iao", Character.valueOf('k'), "in", Character.valueOf('l'), "un", Character.valueOf('z'), "uai", Character.valueOf('x'), "ue", Character.valueOf('x'), "uan", Character.valueOf('c'), "zh", Character.valueOf('v'), "ui", Character.valueOf('v'), "ia", Character.valueOf('b'), "ua", Character.valueOf('b'), "iu", Character.valueOf('n'), "ie", Character.valueOf('m'));
        public static final Converter XIAOHE = new MapConverter("iu", Character.valueOf('q'), "ei", Character.valueOf('w'), "uan", Character.valueOf('r'), "ue", Character.valueOf('t'), "ve", Character.valueOf('t'), "un", Character.valueOf('y'), "sh", Character.valueOf('u'), "ch", Character.valueOf('i'), "uo", Character.valueOf('o'), "ie", Character.valueOf('p'), "ong", Character.valueOf('s'), "iong", Character.valueOf('s'), "ai", Character.valueOf('d'), "en", Character.valueOf('f'), "eng", Character.valueOf('g'), "ang", Character.valueOf('h'), "an", Character.valueOf('j'), "ing", Character.valueOf('k'), "uai", Character.valueOf('k'), "iang", Character.valueOf('l'), "uang", Character.valueOf('l'), "ou", Character.valueOf('z'), "ia", Character.valueOf('x'), "ua", Character.valueOf('x'), "ao", Character.valueOf('c'), "zh", Character.valueOf('v'), "ui", Character.valueOf('v'), "in", Character.valueOf('b'), "iao", Character.valueOf('n'), "ian", Character.valueOf('m'));
        public static final Converter NATURAL = new MapConverter("iu", Character.valueOf('q'), "ia", Character.valueOf('w'), "ua", Character.valueOf('w'), "uan", Character.valueOf('r'), "ue", Character.valueOf('t'), "ve", Character.valueOf('t'), "ing", Character.valueOf('y'), "uai", Character.valueOf('y'), "sh", Character.valueOf('u'), "ch", Character.valueOf('i'), "uo", Character.valueOf('o'), "un", Character.valueOf('p'), "ong", Character.valueOf('s'), "iong", Character.valueOf('s'), "uang", Character.valueOf('d'), "iang", Character.valueOf('d'), "en", Character.valueOf('f'), "eng", Character.valueOf('g'), "ang", Character.valueOf('h'), "an", Character.valueOf('j'), "ao", Character.valueOf('k'), "ai", Character.valueOf('l'), "ei", Character.valueOf('z'), "ie", Character.valueOf('x'), "iao", Character.valueOf('c'), "zh", Character.valueOf('v'), "ui", Character.valueOf('v'), "ou", Character.valueOf('b'), "in", Character.valueOf('n'), "ian", Character.valueOf('m'));
        public static final BiMap<String, Converter> CONVERTERS = ImmutableBiMap.of((Object)"sougou", (Object)SOUGOU, (Object)"microsoft", (Object)MICROSOFT, (Object)"pinyinpp", (Object)PINYINPP, (Object)"xiaohe", (Object)XIAOHE, (Object)"natural", (Object)NATURAL);
    }

    public static interface Converter {
        public IntList convert(String var1);
    }

    public static class MapConverter
    implements Converter {
        private final Object2IntMap<String> map;

        public MapConverter(Object2IntMap<String> map) {
            this.map = map;
        }

        public MapConverter(Object ... args) {
            Object2IntOpenHashMap map = new Object2IntOpenHashMap(args.length / 2);
            for (int i = 0; i < args.length; i += 2) {
                map.put((Object)((String)args[i]), (int)((Character)args[i + 1]).charValue());
            }
            this.map = Object2IntMaps.unmodifiable((Object2IntMap)map);
        }

        @Override
        public IntList convert(String input) {
            int i = this.map.getOrDefault((Object)input, -1);
            if (i == -1) {
                return IntList.of((int[])input.codePoints().toArray());
            }
            return IntList.of((int)i);
        }
    }
}

