/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument.type;

import java.util.Objects;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class TagArgumentType
extends ArgumentType<Unit, String[]> {
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Style STYLE = Style.EMPTY.withColor(TextColor.fromRgb((int)10420212));

    @Override
    public String getName() {
        return "tag";
    }

    @Override
    @Nullable
    public String getPrefix() {
        return "$";
    }

    @Override
    public Style getHighlightedStyle() {
        return STYLE;
    }

    @Override
    public SearchMode getSearchMode() {
        return ConfigObject.getInstance().getTagSearchMode();
    }

    @Override
    public String[] cacheData(EntryStack<?> stack) {
        Stream<TagKey<?>> tags = stack.getTagsFor();
        String[] array = (String[])tags.map(TagArgumentType::toString).toArray(String[]::new);
        return array.length == 0 ? EMPTY_ARRAY : array;
    }

    @Override
    public void matches(String[] data, EntryStack<?> stack, Unit filterData, ArgumentType.ResultSink sink) {
        for (String tag : data) {
            if (tag.isEmpty() || !sink.testString(tag)) continue;
            return;
        }
    }

    @Override
    public Unit prepareSearchFilter(String searchText) {
        return Unit.INSTANCE;
    }

    private static String toString(TagKey<?> tagKey) {
        return Objects.toString(tagKey.location());
    }
}

