/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.screen;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.registry.screen.OverlayRendererProvider;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import org.jetbrains.annotations.Nullable;

public enum DefaultScreenOverlayRenderer implements OverlayRendererProvider
{
    INSTANCE;

    @Nullable
    private ClientGuiEvent.ScreenRenderPre renderPre;
    @Nullable
    private ClientGuiEvent.ContainerScreenRenderBackground renderContainerBg;
    @Nullable
    private ClientGuiEvent.ContainerScreenRenderForeground renderContainerFg;
    @Nullable
    private ClientGuiEvent.ScreenRenderPost renderPost;

    private DefaultScreenOverlayRenderer() {
        ClientGuiEvent.RENDER_PRE.register((screen, graphics, mouseX, mouseY, delta) -> {
            if (this.renderPre != null) {
                return this.renderPre.render(screen, graphics, mouseX, mouseY, delta);
            }
            return EventResult.pass();
        });
        ClientGuiEvent.RENDER_CONTAINER_BACKGROUND.register((screen, graphics, mouseX, mouseY, delta) -> {
            if (this.renderContainerBg != null) {
                this.renderContainerBg.render(screen, graphics, mouseX, mouseY, delta);
            }
        });
        ClientGuiEvent.RENDER_CONTAINER_FOREGROUND.register((screen, graphics, mouseX, mouseY, delta) -> {
            if (this.renderContainerFg != null) {
                this.renderContainerFg.render(screen, graphics, mouseX, mouseY, delta);
            }
        });
        ClientGuiEvent.RENDER_POST.register((screen, graphics, mouseX, mouseY, delta) -> {
            if (this.renderPost != null) {
                this.renderPost.render(screen, graphics, mouseX, mouseY, delta);
            }
        });
    }

    @Override
    public void onApplied(OverlayRendererProvider.Sink sink) {
        int[] rendered = new int[]{0};
        this.renderPre = (screen, graphics, mouseX, mouseY, delta) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return EventResult.pass();
            }
            rendered[0] = 0;
            return EventResult.pass();
        };
        this.renderContainerBg = (screen, graphics, mouseX, mouseY, delta) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn((Screen)screen)) {
                return;
            }
            rendered[0] = 1;
            RoughlyEnoughItemsCoreClient.resetFocused((Screen)screen);
            if (!(screen instanceof DisplayScreen)) {
                sink.render(graphics, mouseX, mouseY, delta);
            }
            RoughlyEnoughItemsCoreClient.resetFocused((Screen)screen);
        };
        this.renderContainerFg = (screen, graphics, mouseX, mouseY, delta) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn((Screen)screen)) {
                return;
            }
            rendered[0] = 2;
            RoughlyEnoughItemsCoreClient.resetFocused((Screen)screen);
            graphics.pose().pushPose();
            graphics.pose().translate((double)(-screen.leftPos), (double)(-screen.topPos), 0.0);
            sink.lateRender(graphics, mouseX, mouseY, delta);
            graphics.pose().popPose();
            RoughlyEnoughItemsCoreClient.resetFocused((Screen)screen);
        };
        this.renderPost = (screen, graphics, mouseX, mouseY, delta) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen) || rendered[0] == 2) {
                return;
            }
            if (screen instanceof AbstractContainerScreen) {
                InternalLogger.getInstance().warn("Screen " + screen.getClass().getName() + " did not render background and foreground! This might cause rendering issues!");
            }
            RoughlyEnoughItemsCoreClient.resetFocused(screen);
            if (rendered[0] == 0 && !(screen instanceof DisplayScreen)) {
                sink.render(graphics, mouseX, mouseY, delta.getRealtimeDeltaTicks());
            }
            rendered[0] = 1;
            if (rendered[0] == 1) {
                sink.lateRender(graphics, mouseX, mouseY, delta.getRealtimeDeltaTicks());
            }
            RoughlyEnoughItemsCoreClient.resetFocused(screen);
        };
    }

    @Override
    public void onRemoved() {
        this.renderPre = null;
        this.renderContainerBg = null;
        this.renderContainerFg = null;
        this.renderPost = null;
    }
}

