/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Color;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchFieldLocation;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.ButtonArea;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.RecipeDisplayExporter;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.toast.ExportRecipeIdentifierToast;
import me.shedaniel.rei.impl.client.gui.widget.DefaultDisplayChoosePageWidget;
import me.shedaniel.rei.impl.client.gui.widget.DisplayCompositeWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.client.gui.widget.TabWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.PanelWidget;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@ApiStatus.Internal
public class DefaultDisplayViewingScreen
extends AbstractDisplayViewingScreen {
    private static final int INNER_PADDING_Y = 36;
    private static final int OUTER_PADDING_TOP = 2;
    private static final int OUTER_PADDING_BOTTOM = 2;
    private static final int DISPLAY_GAP = 4;
    private final Map<Rectangle, Pair<DisplaySpec, List<Widget>>> recipeBounds = Maps.newHashMap();
    private List<Widget> widgets = Lists.newArrayList();
    public int page;
    @Nullable
    private Panel workingStationsBaseWidget;
    private Button recipeBack;
    private Button recipeNext;
    private Button categoryBack;
    private Button categoryNext;
    private final int bestWidthDisplay;
    private final ValueAnimator<Color> darkStripesColor = ValueAnimator.ofColor().withConvention(() -> Color.ofTransparent((int)(REIRuntime.getInstance().isDarkThemeEnabled() ? -12566464 : -6381922)), ValueAnimator.typicalTransitionTime());

    public DefaultDisplayViewingScreen(Map<DisplayCategory<?>, List<DisplaySpec>> categoriesMap, @Nullable CategoryIdentifier<?> category) {
        super(categoriesMap, category);
        this.bounds = new Rectangle(0, 0, 176, 150);
        List<Integer> list = CollectionUtils.mapAndFilter(categoriesMap.entrySet(), Objects::nonNull, entry -> CollectionUtils.mapAndMax((Collection)entry.getValue(), display -> ((DisplayCategory)entry.getKey()).getDisplayWidth(display.provideInternalDisplay()), Comparator.naturalOrder()).orElse(null));
        list.sort(Comparator.naturalOrder());
        int mode = list.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(150);
        int median = list.size() % 2 == 0 ? (list.get(list.size() / 2) + list.get(list.size() / 2 - 1)) / 2 : list.get(list.size() / 2);
        this.bestWidthDisplay = (int)Math.round(((double)mode * 0.5 + (double)median * 1.5) / 2.0);
    }

    @Override
    public void recalculateCategoryPage() {
        this.categoryPages = -1;
    }

    @Nullable
    public Panel getWorkingStationsBaseWidget() {
        return this.workingStationsBaseWidget;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (ConfigObject.getInstance().getNextPageKeybind().matchesKey(keyCode, scanCode)) {
            if (this.recipeNext.isEnabled()) {
                this.recipeNext.onClick();
            }
            return this.recipeNext.isEnabled();
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesKey(keyCode, scanCode)) {
            if (this.recipeBack.isEnabled()) {
                this.recipeBack.onClick();
            }
            return this.recipeBack.isEnabled();
        }
        for (GuiEventListener element : this.children()) {
            if (!element.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (keyCode == 256) {
            Minecraft.getInstance().setScreen(REIRuntime.getInstance().getPreviousScreen());
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void init() {
        super.init();
        this.children().clear();
        this.recipeBounds.clear();
        this.widgets.clear();
        int guiWidth = Math.max(this.bestWidthDisplay + 10 + 14 + 14, 190);
        this.tabs.initTabsSize(guiWidth);
        int topMargin = 2 + this.tabs.tabSize() - 2 + (this.categories.size() > this.tabs.tabsPerPage() ? 16 : 0);
        int bottomMargin = 2 + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.CENTER ? 22 : 0);
        int largestHeight = Math.min(Math.max(this.height - topMargin - bottomMargin, 100), ConfigObject.getInstance().getMaxRecipesPageHeight());
        int maxHeight = Math.min(largestHeight, CollectionUtils.mapAndMax(this.categories, category -> 36 + (category.getDisplayHeight() + 4) * Math.max(1, Math.min(DefaultDisplayViewingScreen.getRecipesPerPage(largestHeight, category) + 1, Math.max(((List)this.categoryMap.get(category)).size(), ConfigObject.getInstance().getMaxRecipePerPage()))), Comparator.naturalOrder()).orElse(66));
        this.bounds = new Rectangle(this.width / 2 - guiWidth / 2, topMargin + (this.height - topMargin - bottomMargin) / 2 - maxHeight / 2, guiWidth, maxHeight);
        this.initTabs(guiWidth);
        this.widgets.addAll(this.tabs.widgets());
        this.page = Mth.clamp((int)this.page, (int)0, (int)(this.getCurrentTotalPages() - 1));
        this.categoryBack = Widgets.createButton(new Rectangle(this.bounds.getCenterX() - guiWidth / 2 + 5, this.bounds.getY() + 5, 12, 12), (Component)Component.empty()).onClick(button -> this.previousCategory()).tooltipLine((Component)Component.translatable((String)"text.rei.previous_category"));
        this.widgets.add(this.categoryBack);
        this.widgets.add(Widgets.createClickableLabel(new Point(this.bounds.getCenterX(), this.bounds.getY() + 7), this.getCurrentCategory().getTitle(), clickableLabelWidget -> ViewSearchBuilder.builder().addAllCategories().open()).tooltip(new Component[]{Component.translatable((String)"text.rei.view_all_categories"), Component.translatable((String)"text.rei.view_all_categories.tooltip", (Object[])new Object[]{CategoryRegistry.getInstance().stream().filter(config -> !DisplayRegistry.getInstance().get(config.getCategoryIdentifier()).isEmpty()).count()}).withStyle(ChatFormatting.DARK_GRAY)}));
        this.categoryNext = Widgets.createButton(new Rectangle(this.bounds.getCenterX() + guiWidth / 2 - 17, this.bounds.getY() + 5, 12, 12), (Component)Component.literal((String)"")).onClick(button -> this.nextCategory()).tooltipLine((Component)Component.translatable((String)"text.rei.next_category"));
        this.widgets.add(this.categoryNext);
        this.categoryBack.setEnabled(this.categories.size() > 1);
        this.categoryNext.setEnabled(this.categories.size() > 1);
        this.widgets.add(Widgets.withTranslate(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            Rectangle recipeBackBounds = this.recipeBack.getBounds();
            Rectangle recipeNextBounds = this.recipeNext.getBounds();
            Rectangle categoryBackBounds = this.categoryBack.getBounds();
            Rectangle categoryNextBounds = this.categoryNext.getBounds();
            graphics.pose().pushPose();
            graphics.pose().translate(0.5, 0.5, 0.0);
            graphics.blit(InternalTextures.ARROW_LEFT_TEXTURE, recipeBackBounds.x + 2, recipeBackBounds.y + 2, 0.0f, 0.0f, 8, 8, 8, 8);
            graphics.blit(InternalTextures.ARROW_LEFT_TEXTURE, categoryBackBounds.x + 2, categoryBackBounds.y + 2, 0.0f, 0.0f, 8, 8, 8, 8);
            graphics.pose().translate(-0.5, 0.0, 0.0);
            graphics.blit(InternalTextures.ARROW_RIGHT_TEXTURE, recipeNextBounds.x + 2, recipeNextBounds.y + 2, 0.0f, 0.0f, 8, 8, 8, 8);
            graphics.blit(InternalTextures.ARROW_RIGHT_TEXTURE, categoryNextBounds.x + 2, categoryNextBounds.y + 2, 0.0f, 0.0f, 8, 8, 8, 8);
            graphics.pose().popPose();
        }), 0.0, 0.0, 1.0));
        this.recipeBack = Widgets.createButton(new Rectangle(this.bounds.getCenterX() - guiWidth / 2 + 5, this.bounds.getY() + 19, 12, 12), (Component)Component.literal((String)"")).onClick(button -> {
            --this.page;
            if (this.page < 0) {
                this.page = this.getCurrentTotalPages() - 1;
            }
            this.init();
        }).tooltipLine((Component)Component.translatable((String)"text.rei.previous_page"));
        this.widgets.add(this.recipeBack);
        this.widgets.add(Widgets.createClickableLabel(new Point(this.bounds.getCenterX(), this.bounds.getY() + 21), (Component)Component.empty(), label -> {
            if (!Screen.hasShiftDown()) {
                this.page = 0;
                this.init();
            } else {
                ScreenOverlayImpl.getInstance().choosePageWidget = new DefaultDisplayChoosePageWidget(page -> {
                    this.page = page;
                    this.init();
                }, this.page, this.getCurrentTotalPages());
            }
        }).onRender((matrices, label) -> {
            label.setMessage((FormattedText)Component.literal((String)String.format("%d/%d", this.page + 1, this.getCurrentTotalPages())));
            label.setClickable(this.getCurrentTotalPages() > 1);
        }).tooltipFunction(label -> {
            Component[] componentArray;
            if (label.isClickable()) {
                Component[] componentArray2 = new Component[3];
                componentArray2[0] = Component.translatable((String)"text.rei.go_back_first_page");
                componentArray2[1] = Component.literal((String)" ");
                componentArray = componentArray2;
                componentArray2[2] = Component.translatable((String)"text.rei.shift_click_to", (Object[])new Object[]{Component.translatable((String)"text.rei.choose_page")}).withStyle(ChatFormatting.GRAY);
            } else {
                componentArray = null;
            }
            return componentArray;
        }));
        this.recipeNext = Widgets.createButton(new Rectangle(this.bounds.getCenterX() + guiWidth / 2 - 17, this.bounds.getY() + 19, 12, 12), (Component)Component.literal((String)"")).onClick(button -> {
            ++this.page;
            if (this.page >= this.getCurrentTotalPages()) {
                this.page = 0;
            }
            this.init();
        }).tooltipLine((Component)Component.translatable((String)"text.rei.next_page"));
        this.widgets.add(this.recipeNext);
        this.recipeBack.setEnabled(this.getCurrentTotalPages() > 1);
        this.recipeNext.setEnabled(this.getCurrentTotalPages() > 1);
        this.initDisplays();
        this.widgets = CollectionUtils.map(this.widgets, widget -> Widgets.withTranslate(widget, 0.0, 0.0, 10.0));
        this.widgets.add(Widgets.withTranslate(new PanelWidget(this.bounds), 0.0, 0.0, 5.0));
        this.widgets.add(Widgets.withTranslate(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            graphics.fill(this.bounds.getCenterX() - guiWidth / 2 + 17, this.bounds.y + 5, this.bounds.getCenterX() + guiWidth / 2 - 17, this.bounds.y + 17, ((Color)this.darkStripesColor.value()).getColor());
            graphics.fill(this.bounds.getCenterX() - guiWidth / 2 + 17, this.bounds.y + 19, this.bounds.getCenterX() + guiWidth / 2 - 17, this.bounds.y + 31, ((Color)this.darkStripesColor.value()).getColor());
        }), 0.0, 0.0, 6.0));
        this.initWorkstations(this.widgets);
        this.children().addAll(this.widgets);
    }

    private void initDisplays() {
        Optional<ButtonArea> plusButtonArea = CategoryRegistry.getInstance().get(this.getCurrentCategoryId()).getPlusButtonArea();
        int displayHeight = this.getCurrentCategory().getDisplayHeight();
        List<DisplaySpec> currentDisplayed = this.getCurrentDisplayed();
        for (int i = 0; i < currentDisplayed.size(); ++i) {
            ArrayList<Widget> setupDisplay;
            DisplaySpec display = currentDisplayed.get(i);
            Supplier<Display> displaySupplier = display::provideInternalDisplay;
            int displayWidth = this.getCurrentCategory().getDisplayWidth(displaySupplier.get());
            Rectangle displayBounds = new Rectangle(this.getBounds().getCenterX() - displayWidth / 2, this.getBounds().getCenterY() + 16 - displayHeight * (this.getRecipesPerPage() + 1) / 2 - 2 * (this.getRecipesPerPage() + 1) + displayHeight * i + 4 * i, displayWidth, displayHeight);
            try {
                setupDisplay = this.getCurrentCategoryView(display.provideInternalDisplay()).setupDisplay(display.provideInternalDisplay(), displayBounds);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                setupDisplay = new ArrayList();
                setupDisplay.add(Widgets.createRecipeBase(displayBounds).color(-4521984));
                setupDisplay.add(Widgets.createLabel(new Point(displayBounds.getCenterX(), displayBounds.getCenterY() - 8), (Component)Component.literal((String)"Failed to initiate setupDisplay")));
                setupDisplay.add(Widgets.createLabel(new Point(displayBounds.getCenterX(), displayBounds.getCenterY() + 1), (Component)Component.literal((String)"Check console for error")));
            }
            this.setupTags(setupDisplay);
            this.transformFiltering(setupDisplay);
            this.transformIngredientNotice(setupDisplay, this.ingredientStackToNotice);
            this.transformResultNotice(setupDisplay, this.resultStackToNotice);
            this.unifyIngredients(setupDisplay);
            for (EntryWidget widget : Widgets.walk(this.widgets, EntryWidget.class::isInstance)) {
                widget.removeTagMatch = true;
            }
            this.recipeBounds.put(displayBounds, (Pair<DisplaySpec, List<Widget>>)Pair.of((Object)display, setupDisplay));
            this.widgets.add(new DisplayCompositeWidget(display, setupDisplay, displayBounds));
            if (!plusButtonArea.isPresent()) continue;
            this.widgets.add(Widgets.withTranslate(InternalWidgets.createAutoCraftingButtonWidget(displayBounds, plusButtonArea.get().get(displayBounds), (Component)Component.literal((String)plusButtonArea.get().getButtonText()), displaySupplier, display::provideInternalDisplayIds, setupDisplay, this.getCurrentCategory()), 0.0, 0.0, 100.0));
        }
    }

    private void initWorkstations(List<Widget> widgets) {
        this.workingStationsBaseWidget = null;
        List<EntryIngredient> workstations = CategoryRegistry.getInstance().get(this.getCurrentCategoryId()).getWorkstations();
        if (!workstations.isEmpty()) {
            int hh = Mth.floor((float)((float)(this.bounds.height - 16) / 18.0f));
            int actualHeight = Math.min(hh, workstations.size());
            int innerWidth = Mth.ceil((float)((float)workstations.size() / (float)hh));
            int xx = this.bounds.x - (8 + innerWidth * 16) + 6;
            int yy = this.bounds.y + 16;
            this.workingStationsBaseWidget = Widgets.createCategoryBase(new Rectangle(xx - 5, yy - 5, 15 + innerWidth * 16, 10 + actualHeight * 16));
            widgets.add(this.workingStationsBaseWidget);
            widgets.add(Widgets.createSlotBase(new Rectangle(xx - 1, yy - 1, innerWidth * 16 + 2, actualHeight * 16 + 2)));
            int index = 0;
            xx += (innerWidth - 1) * 16;
            for (EntryIngredient workingStation : workstations) {
                widgets.add(new WorkstationSlotWidget(xx, yy, workingStation));
                yy += 16;
                if (++index < hh) continue;
                index = 0;
                yy = this.bounds.y + 16;
                xx -= 16;
            }
        }
    }

    public List<Widget> widgets() {
        this.widgets.sort(Comparator.comparingDouble(Widget::getZRenderingPriority));
        return this.widgets;
    }

    public List<DisplaySpec> getCurrentDisplayed() {
        ArrayList list = Lists.newArrayList();
        int recipesPerPage = this.getRecipesPerPage();
        List displays = (List)this.categoryMap.get(this.getCurrentCategory());
        for (int i = 0; i <= recipesPerPage; ++i) {
            if (this.page * (recipesPerPage + 1) + i >= displays.size()) continue;
            list.add((DisplaySpec)displays.get(this.page * (recipesPerPage + 1) + i));
        }
        return list;
    }

    public int getPage() {
        return this.page;
    }

    public int getCategoryPage() {
        return this.categoryPages;
    }

    private int getRecipesPerPage() {
        return DefaultDisplayViewingScreen.getRecipesPerPage(this.bounds.height, this.getCurrentCategory());
    }

    private static int getRecipesPerPage(int totalHeight, DisplayCategory<?> category) {
        if (category.getFixedDisplaysPerPage() > 0) {
            return category.getFixedDisplaysPerPage() - 1;
        }
        int height = category.getDisplayHeight();
        return Mth.clamp((int)(Mth.floor((double)(((double)totalHeight - 36.0) / ((double)height + 4.0))) - 1), (int)0, (int)Math.min(ConfigObject.getInstance().getMaxRecipePerPage() - 1, category.getMaximumDisplaysPerPage() - 1));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.darkStripesColor.update((double)delta);
        super.render(graphics, mouseX, mouseY, delta);
        DefaultDisplayViewingScreen.getOverlay().render(graphics, mouseX, mouseY, delta);
        for (Widget widget : this.widgets()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            widget.render(graphics, mouseX, mouseY, delta);
        }
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesCurrentKey() || export.matchesCurrentMouse()) {
            for (Rectangle bounds : Iterables.concat(this.recipeBounds.keySet(), (Iterable)Iterables.transform(this.getTabs(), TabWidget::getBounds))) {
                graphics.pose().pushPose();
                graphics.pose().translate(0.0, 0.0, 480.0);
                if (bounds.contains(mouseX, mouseY)) {
                    graphics.fillGradient(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 1744822402, 1744822402);
                    MutableComponent text = Component.translatable((String)"text.rei.release_export", (Object[])new Object[]{export.getLocalizedName().plainCopy().getString()});
                    graphics.pose().pushPose();
                    graphics.pose().translate(0.0, 0.0, 10.0);
                    Matrix4f matrix4f = graphics.pose().last().pose();
                    this.font.drawInBatch(text.getVisualOrderText(), (float)bounds.getCenterX() - (float)this.font.width((FormattedText)text) / 2.0f, (float)bounds.getCenterY() - 4.5f, -16777216, false, matrix4f, (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    graphics.flush();
                    graphics.pose().popPose();
                } else {
                    graphics.fillGradient(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 0x67FFFFFF, 0x67FFFFFF);
                }
                graphics.pose().popPose();
            }
        }
    }

    private Iterable<TabWidget> getTabs() {
        return Widgets.walk(this.widgets(), widget -> widget instanceof TabWidget);
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesKey(keyCode, scanCode) && this.checkExportDisplays()) {
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public int getCurrentTotalPages() {
        return this.getTotalPages(this.selectedCategoryIndex);
    }

    public int getTotalPages(int categoryIndex) {
        return Mth.ceil((double)((double)((List)this.categoryMap.get(this.categories.get(categoryIndex))).size() / (double)(this.getRecipesPerPage() + 1)));
    }

    @Override
    public boolean charTyped(char character, int modifiers) {
        for (GuiEventListener listener : this.children()) {
            if (!listener.charTyped(character, modifiers)) continue;
            return true;
        }
        return super.charTyped(character, modifiers);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (GuiEventListener entry : this.children()) {
            if (!entry.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesMouse(button) && this.checkExportDisplays()) {
            return true;
        }
        for (GuiEventListener entry : this.children()) {
            if (!entry.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private boolean checkExportDisplays() {
        Rectangle bounds;
        for (Map.Entry<Rectangle, Pair<DisplaySpec, List<Widget>>> entry : this.recipeBounds.entrySet()) {
            bounds = entry.getKey();
            if (!bounds.contains(PointHelper.ofMouse())) continue;
            RecipeDisplayExporter.exportRecipeDisplay(bounds, (DisplaySpec)entry.getValue().left(), (List)entry.getValue().right(), true);
            return true;
        }
        for (TabWidget tab : this.getTabs()) {
            bounds = tab.getBounds();
            if (!bounds.contains(PointHelper.ofMouse())) continue;
            this.minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
                if (confirmed) {
                    for (DisplaySpec spec : this.categoryMap.getOrDefault(tab.category, Collections.emptyList())) {
                        List<Widget> setupDisplay;
                        Display display = spec.provideInternalDisplay();
                        int displayWidth = this.getCurrentCategory().getDisplayWidth(display);
                        int displayHeight = this.getCurrentCategory().getDisplayHeight();
                        Rectangle displayBounds = new Rectangle(0, 0, displayWidth, displayHeight);
                        try {
                            setupDisplay = this.getCurrentCategoryView(display).setupDisplay(display, displayBounds);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            setupDisplay = new ArrayList<Widget>();
                            setupDisplay.add(Widgets.createRecipeBase(displayBounds).color(-4521984));
                            setupDisplay.add(Widgets.createLabel(new Point(displayBounds.getCenterX(), displayBounds.getCenterY() - 8), (Component)Component.literal((String)"Failed to initiate setupDisplay")));
                            setupDisplay.add(Widgets.createLabel(new Point(displayBounds.getCenterX(), displayBounds.getCenterY() + 1), (Component)Component.literal((String)"Check console for error")));
                        }
                        this.setupTags(setupDisplay);
                        this.transformFiltering(setupDisplay);
                        this.transformIngredientNotice(setupDisplay, this.ingredientStackToNotice);
                        this.transformResultNotice(setupDisplay, this.resultStackToNotice);
                        this.unifyIngredients(setupDisplay);
                        for (EntryWidget widget : Widgets.walk(this.widgets(), EntryWidget.class::isInstance)) {
                            widget.removeTagMatch = true;
                        }
                        RecipeDisplayExporter.exportRecipeDisplay(displayBounds, spec, setupDisplay, false);
                    }
                    ExportRecipeIdentifierToast.addToast(I18n.get((String)"msg.rei.exported_recipe", (Object[])new Object[0]), I18n.get((String)"msg.rei.exported_recipe.desc", (Object[])new Object[0]));
                }
                this.minecraft.setScreen(null);
            }, (Component)Component.translatable((String)"text.rei.ask_to_export", (Object[])new Object[]{tab.categoryName}), (Component)Component.translatable((String)"text.rei.ask_to_export.subtitle", (Object[])new Object[]{this.categoryMap.getOrDefault(tab.category, Collections.emptyList()).size()})));
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        REIRuntimeImpl.isWithinRecipeViewingScreen = true;
        for (GuiEventListener listener : this.children()) {
            if (!listener.mouseScrolled(mouseX, mouseY, amountX, amountY)) continue;
            REIRuntimeImpl.isWithinRecipeViewingScreen = false;
            return true;
        }
        REIRuntimeImpl.isWithinRecipeViewingScreen = false;
        if (this.getBounds().contains(PointHelper.ofMouse())) {
            if (amountY > 0.0 && this.recipeBack.isEnabled()) {
                this.recipeBack.onClick();
            } else if (amountY < 0.0 && this.recipeNext.isEnabled()) {
                this.recipeNext.onClick();
            }
        }
        return super.mouseScrolled(mouseX, mouseY, amountX, amountY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (ConfigObject.getInstance().getNextPageKeybind().matchesMouse(button)) {
            if (this.recipeNext.isEnabled()) {
                this.recipeNext.onClick();
            }
            return this.recipeNext.isEnabled();
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesMouse(button)) {
            if (this.recipeBack.isEnabled()) {
                this.recipeBack.onClick();
            }
            return this.recipeBack.isEnabled();
        }
        if (ConfigObject.getInstance().getPreviousScreenKeybind().matchesMouse(button)) {
            if (REIRuntimeImpl.getInstance().hasLastDisplayScreen()) {
                this.minecraft.setScreen(REIRuntimeImpl.getInstance().getLastDisplayScreen());
            } else {
                this.minecraft.setScreen(REIRuntime.getInstance().getPreviousScreen());
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public static class WorkstationSlotWidget
    extends EntryWidget {
        public WorkstationSlotWidget(int x, int y, EntryIngredient widgets) {
            super(new Point(x, y));
            this.entries((Collection)widgets);
            this.noBackground();
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return this.getInnerBounds().contains(mouseX, mouseY);
        }
    }
}

