/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.performance.entry;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.impl.client.gui.performance.PerformanceScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PerformanceEntryImpl
extends PerformanceScreen.PerformanceEntry {
    private final Component name;
    public final long time;

    public PerformanceEntryImpl(Component name, long time) {
        this.name = name;
        this.time = time;
    }

    public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.drawString(Minecraft.getInstance().font, this.name.getVisualOrderText(), x, y + 6, -1);
        FormattedCharSequence timeText = PerformanceScreen.formatTime(this.time, false);
        graphics.drawString(Minecraft.getInstance().font, timeText, x + entryWidth - 6 - 4 - Minecraft.getInstance().font.width(timeText), y + 6, -1);
    }

    public int getItemHeight() {
        return 24;
    }

    @Override
    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }

    public List<? extends NarratableEntry> narratables() {
        return Collections.emptyList();
    }
}

