/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.modules.entries;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.modules.AbstractMenuEntry;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvents;

public class ToggleMenuEntry
extends AbstractMenuEntry {
    public final Component text;
    public final BooleanSupplier supplier;
    public final BooleanUnaryOperator consumer;
    public BooleanSupplier active = () -> true;
    public Supplier<Tooltip> tooltip = () -> null;
    private int textWidth = -69;

    public static ToggleMenuEntry of(Component text, BooleanSupplier supplier, BooleanConsumer consumer) {
        return new ToggleMenuEntry(text, supplier, b -> {
            consumer.accept(b);
            return true;
        });
    }

    public static ToggleMenuEntry ofDeciding(Component text, BooleanSupplier supplier, BooleanUnaryOperator consumer) {
        return new ToggleMenuEntry(text, supplier, consumer);
    }

    protected ToggleMenuEntry(Component text, BooleanSupplier supplier, BooleanUnaryOperator consumer) {
        this.text = text;
        this.supplier = supplier;
        this.consumer = consumer;
    }

    public ToggleMenuEntry withActive(BooleanSupplier active) {
        this.active = active;
        return this;
    }

    public ToggleMenuEntry withTooltip(Supplier<Tooltip> tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    private int getTextWidth() {
        if (this.textWidth == -69) {
            this.textWidth = Math.max(0, this.font.width((FormattedText)this.text));
        }
        return this.textWidth;
    }

    @Override
    public int getEntryWidth() {
        return this.getTextWidth() + 4 + 8;
    }

    @Override
    public int getEntryHeight() {
        return 12;
    }

    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.isSelected() && this.active.getAsBoolean()) {
            graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getEntryHeight(), -12237499);
            Tooltip tooltip = this.tooltip.get();
            if (tooltip != null) {
                ArrayList areas = Lists.newArrayList((Iterable)ScissorsHandler.INSTANCE.getScissorsAreas());
                ScissorsHandler.INSTANCE.clearScissors();
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, 0.0f, -400.0f);
                ScreenOverlayImpl.getInstance().renderTooltip(graphics, tooltip);
                graphics.pose().popPose();
                for (Rectangle area : areas) {
                    ScissorsHandler.INSTANCE.scissor(area);
                }
            }
        }
        graphics.drawString(this.font, this.text, this.getX() + 2, this.getY() + 2, this.isSelected() && this.active.getAsBoolean() ? 0xFFFFFF : 0x888888, false);
        if (this.supplier.getAsBoolean()) {
            graphics.drawString(this.font, "\u2714", this.getX() + this.getWidth() - 2 - this.font.width("\u2714"), this.getY() + 2, this.isSelected() && this.active.getAsBoolean() ? 0xFFFFFF : 0x888888, false);
        }
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int button) {
        if (!this.active.getAsBoolean()) {
            return false;
        }
        if (this.consumer.apply(!this.supplier.getAsBoolean())) {
            REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
        }
        ConfigManager.getInstance().saveConfig();
        this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        return true;
    }

    @FunctionalInterface
    public static interface BooleanUnaryOperator {
        public boolean apply(boolean var1);
    }
}

