/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.forge;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.EventHooks;

public class CreativeModeTabCollectorImpl {
    public static Map<CreativeModeTab, Collection<ItemStack>> collectTabs() {
        LinkedHashMap<CreativeModeTab, Collection<ItemStack>> map = new LinkedHashMap<CreativeModeTab, Collection<ItemStack>>();
        FeatureFlagSet featureFlags = FeatureFlags.REGISTRY.allFlags();
        CreativeModeTab.ItemDisplayParameters parameters = new CreativeModeTab.ItemDisplayParameters(featureFlags, true, (HolderLookup.Provider)BasicDisplay.registryAccess());
        for (CreativeModeTab tab : CreativeModeTabs.allTabs()) {
            if (tab.getType() == CreativeModeTab.Type.HOTBAR || tab.getType() == CreativeModeTab.Type.INVENTORY) continue;
            try {
                CreativeModeTab.ItemDisplayBuilder builder = new CreativeModeTab.ItemDisplayBuilder(tab, featureFlags);
                ResourceKey resourceKey = (ResourceKey)BuiltInRegistries.CREATIVE_MODE_TAB.getResourceKey((Object)tab).orElseThrow(() -> new IllegalStateException("Unregistered creative tab: " + String.valueOf(tab)));
                EventHooks.onCreativeModeTabBuildContents((CreativeModeTab)tab, (ResourceKey)resourceKey, (CreativeModeTab.DisplayItemsGenerator)tab.displayItemsGenerator, (CreativeModeTab.ItemDisplayParameters)parameters, (stack, visibility) -> {
                    if (visibility == CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY) {
                        return;
                    }
                    builder.accept(stack, visibility);
                });
                map.put(tab, builder.tabContents);
            }
            catch (Throwable throwable) {
                InternalLogger.getInstance().error("Failed to collect creative tab: " + String.valueOf(tab), throwable);
            }
        }
        return map;
    }
}

