/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.screen.widget;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import tocraft.craftedcore.patched.client.CGraphics;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.remorphed.screen.RemorphedScreen;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;
import tocraft.walkers.network.impl.SwapVariantPackets;

@OnlyIn(value=Dist.CLIENT)
public class SpecialShapeWidget
extends AbstractButton {
    private final RemorphedScreen parent;
    private final boolean isCurrent;
    private final boolean isAvailable;

    public SpecialShapeWidget(int x, int y, int width, int height, RemorphedScreen parent) {
        super(x, y, width, height, Component.nullToEmpty((String)""));
        LivingEntity livingEntity;
        this.parent = parent;
        CompoundTag nbt = new CompoundTag();
        if (Minecraft.getInstance().player != null && (livingEntity = PlayerShape.getCurrentShape((Player)Minecraft.getInstance().player)) instanceof Wolf) {
            Wolf wolf = (Wolf)livingEntity;
            wolf.saveWithoutId(nbt);
        }
        this.isCurrent = nbt.contains("isSpecial") && nbt.getBoolean("isSpecial");
        this.isAvailable = Remorphed.canUseEveryShape((Player)Minecraft.getInstance().player) || PlayerMorph.getUnlockedShapes((Player)Minecraft.getInstance().player).keySet().stream().anyMatch(type -> type.getEntityType().equals(EntityType.WOLF));
        this.setTooltip(Tooltip.create((Component)Component.translatable((String)(this.isAvailable ? "remorphed.special_shape_available" : "remorphed.special_shape_unavailable"))));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        CGraphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Remorphed.id("textures/gui/wolf.png"), (int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight(), (float)0.0f, (float)0.0f, (int)15, (int)15, (int)15, (int)15);
        if (!this.isCurrent && !this.isAvailable) {
            CGraphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Remorphed.id("textures/gui/unavailable.png"), (int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight(), (float)0.0f, (float)0.0f, (int)15, (int)15, (int)15, (int)15);
        }
    }

    public void onPress() {
        UUID profileId = Minecraft.getInstance().getUser().getProfileId();
        if (!this.isCurrent && this.isAvailable && Walkers.hasSpecialShape((UUID)profileId)) {
            TypeProvider typeProvider = TypeProviderRegistry.getProvider((EntityType)EntityType.WOLF);
            int range = typeProvider != null ? typeProvider.getRange() : -1;
            NetworkHandler.sendSwap2ndShapeRequest(Objects.requireNonNull(ShapeType.from((EntityType)EntityType.WOLF, (int)-1)));
            SwapVariantPackets.sendSwapRequest((int)(range + 1));
            this.parent.onClose();
        }
    }

    public void updateWidgetNarration(NarrationElementOutput builder) {
    }
}

