/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.screen.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import tocraft.craftedcore.platform.PlayerProfile;
import tocraft.remorphed.impl.FakeClientPlayer;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.remorphed.screen.RemorphedScreen;
import tocraft.remorphed.screen.widget.ShapeWidget;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.impl.SwapPackets;

@OnlyIn(value=Dist.CLIENT)
public class SkinWidget
extends ShapeWidget {
    private final PlayerProfile skin;
    private final FakeClientPlayer fakePlayer;
    private final int size;

    public SkinWidget(float x, float y, float width, float height, PlayerProfile skin, FakeClientPlayer fakePlayer, RemorphedScreen parent, boolean isFavorite, boolean isCurrent) {
        super(x, y, width, height, parent, isFavorite, isCurrent);
        this.size = (int)(25.0f * (1.0f / Math.max(fakePlayer.getBbHeight(), fakePlayer.getBbWidth())));
        this.skin = skin;
        this.fakePlayer = fakePlayer;
        this.setTooltip(Tooltip.create((Component)Component.literal((String)skin.name())));
    }

    @Override
    protected void sendFavoriteRequest(boolean isFavorite) {
        NetworkHandler.sendFavoriteRequest(this.skin, isFavorite);
    }

    @Override
    protected void sendSwap2ndShapeRequest() {
        NetworkHandler.sendSwapSkinRequest(this.skin);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && ((PlayerDataProvider)player).walkers$getCurrentShape() != null) {
            SwapPackets.sendSwapRequest();
        }
    }

    @Override
    protected void renderShape(GuiGraphics guiGraphics) {
        if (this.skin.skin() != null) {
            InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)((float)this.getX() + (float)this.getWidth() / 2.0f), (float)((int)((float)this.getY() + (float)this.getHeight() * 0.75f)), (float)this.size, (Vector3f)new Vector3f(), (Quaternionf)new Quaternionf().rotationXYZ(0.43633232f, (float)Math.PI, (float)Math.PI), null, (LivingEntity)this.fakePlayer);
        }
    }
}

