/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.screen.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import tocraft.craftedcore.patched.client.CGraphics;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.screen.RemorphedScreen;

public abstract class ShapeWidget
extends AbstractButton {
    private final RemorphedScreen parent;
    private boolean crashed = false;
    private boolean isFavorite;
    private final boolean isCurrent;

    public ShapeWidget(float x, float y, float width, float height, RemorphedScreen parent, boolean isFavorite, boolean isCurrent) {
        super((int)x, (int)y, (int)width, (int)height, Component.nullToEmpty((String)""));
        this.parent = parent;
        this.isFavorite = isFavorite;
        this.isCurrent = isCurrent;
    }

    protected abstract void sendFavoriteRequest(boolean var1);

    protected abstract void sendSwap2ndShapeRequest();

    protected abstract void renderShape(GuiGraphics var1);

    protected void setCrashed() {
        this.crashed = true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean bl;
        boolean bl2 = bl = mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height);
        if (bl && Minecraft.getInstance().player != null) {
            if (button == 0 && !this.isCurrent) {
                this.sendSwap2ndShapeRequest();
                this.parent.onClose();
            } else if (button == 1) {
                this.isFavorite = !this.isFavorite;
                this.sendFavoriteRequest(this.isFavorite);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (!this.crashed) {
            this.renderShape(guiGraphics);
            if (this.isCurrent) {
                CGraphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Remorphed.id("textures/gui/selected.png"), (int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight(), (float)0.0f, (float)0.0f, (int)48, (int)32, (int)48, (int)32);
            }
            if (this.isFavorite) {
                CGraphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Remorphed.id("textures/gui/favorite.png"), (int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight(), (float)0.0f, (float)0.0f, (int)48, (int)32, (int)48, (int)32);
            }
        }
    }

    public void onPress() {
    }

    public void updateWidgetNarration(NarrationElementOutput builder) {
    }
}

