/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.screen.widget;

import dev.tocraft.skinshifter.SkinShifter;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import tocraft.craftedcore.patched.client.CGraphics;
import tocraft.craftedcore.platform.PlayerProfile;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.remorphed.screen.RemorphedScreen;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.impl.SwapPackets;

@OnlyIn(value=Dist.CLIENT)
public class PlayerWidget
extends AbstractButton {
    private final RemorphedScreen parent;

    public PlayerWidget(int x, int y, int width, int height, RemorphedScreen parent) {
        super(x, y, width, height, Component.nullToEmpty((String)""));
        this.parent = parent;
        this.setTooltip(Tooltip.create((Component)Component.translatable((String)"remorphed.player_icon")));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            ResourceLocation skinLocation = player.getSkin().texture();
            if (Remorphed.foundSkinShifter && SkinShifter.getCurrentSkin((Player)player) != null) {
                PlayerProfile playerProfile = PlayerProfile.getCachedProfile((UUID)player.getUUID());
                if (playerProfile != null && playerProfile.skin() != null) {
                    skinLocation = playerProfile.getSkinId();
                } else {
                    CompletableFuture.runAsync(() -> PlayerWidget.lambda$renderWidget$0((AbstractClientPlayer)player));
                }
            }
            CGraphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)skinLocation, (int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight(), (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            CGraphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)skinLocation, (int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight(), (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        } else {
            super.renderWidget(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public void onPress() {
        if (Minecraft.getInstance().player != null) {
            if (((PlayerDataProvider)Minecraft.getInstance().player).walkers$getCurrentShape() != null) {
                SwapPackets.sendSwapRequest();
                this.parent.onClose();
            }
            if (Remorphed.foundSkinShifter && SkinShifter.getCurrentSkin((Player)Minecraft.getInstance().player) != Minecraft.getInstance().player.getUUID()) {
                NetworkHandler.sendResetSkinPacket();
                this.parent.onClose();
            }
        }
    }

    public void updateWidgetNarration(NarrationElementOutput builder) {
    }

    private static /* synthetic */ void lambda$renderWidget$0(AbstractClientPlayer player) {
        PlayerProfile.ofId((UUID)player.getUUID());
    }
}

