/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.screen.widget;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import tocraft.craftedcore.patched.client.CGraphics;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.remorphed.screen.RemorphedScreen;
import tocraft.remorphed.screen.widget.ShapeWidget;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;

@OnlyIn(value=Dist.CLIENT)
public class EntityWidget<T extends LivingEntity>
extends ShapeWidget {
    private final ShapeType<T> type;
    private final T entity;
    private final int size;

    public EntityWidget(float x, float y, float width, float height, ShapeType<T> type, T entity, RemorphedScreen parent, boolean isFavorite, boolean current) {
        super((int)x, (int)y, (int)width, (int)height, parent, isFavorite, current);
        this.size = (int)(25.0f * (1.0f / Math.max(entity.getBbHeight(), entity.getBbWidth())));
        this.type = type;
        this.entity = entity;
        entity.setGlowingTag(true);
        this.setTooltip(Tooltip.create((Component)ShapeType.createTooltipText(entity)));
    }

    @Override
    protected void sendFavoriteRequest(boolean isFavorite) {
        NetworkHandler.sendFavoriteRequest(this.type, isFavorite);
    }

    @Override
    protected void sendSwap2ndShapeRequest() {
        NetworkHandler.sendSwap2ndShapeRequest(this.type);
    }

    @Override
    protected void renderShape(GuiGraphics guiGraphics) {
        if (Remorphed.displayTraitsInMenu) {
            int blitOffset = 0;
            int rowIndex = 0;
            ArrayList<ResourceLocation> renderedTraits = new ArrayList<ResourceLocation>();
            for (ShapeTrait trait : TraitRegistry.getAll(this.entity)) {
                if (trait == null || trait.getIcon() == null || renderedTraits.contains(trait.getId()) && !trait.iconMightDiffer()) continue;
                CGraphics.blit((GuiGraphics)guiGraphics, (int)(this.getX() + rowIndex), (int)(this.getY() + blitOffset), (int)0, (int)18, (int)18, (TextureAtlasSprite)trait.getIcon());
                if (blitOffset >= this.getHeight() - 18) {
                    rowIndex += 18;
                    blitOffset = 0;
                } else {
                    blitOffset += 18;
                }
                if (rowIndex >= this.getWidth() - 18) break;
                renderedTraits.add(trait.getId());
            }
        }
        try {
            InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)((float)this.getX() + (float)this.getWidth() / 2.0f), (float)((int)((float)this.getY() + (float)this.getHeight() * 0.75f)), (float)this.size, (Vector3f)new Vector3f(), (Quaternionf)new Quaternionf().rotationXYZ(0.43633232f, (float)Math.PI, (float)Math.PI), null, this.entity);
        }
        catch (Exception e) {
            Remorphed.LOGGER.error("Error while rendering {}", (Object)ShapeType.createTooltipText(this.entity).getString(), (Object)e);
            this.setCrashed();
            MultiBufferSource.BufferSource immediate = Minecraft.getInstance().renderBuffers().bufferSource();
            immediate.endBatch();
            EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
            entityRenderDispatcher.setRenderShadow(true);
            RenderSystem.getModelViewStack().popMatrix();
            Lighting.setupFor3DItems();
        }
    }
}

