/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.screen;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.tocraft.skinshifter.SkinShifter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.PlayerProfile;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.FakeClientPlayer;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.remorphed.mixin.accessor.ScreenAccessor;
import tocraft.remorphed.screen.RemorphedHelpScreen;
import tocraft.remorphed.screen.widget.EntityWidget;
import tocraft.remorphed.screen.widget.PlayerWidget;
import tocraft.remorphed.screen.widget.SearchWidget;
import tocraft.remorphed.screen.widget.ShapeWidget;
import tocraft.remorphed.screen.widget.SkinWidget;
import tocraft.remorphed.screen.widget.SpecialShapeWidget;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;

@OnlyIn(value=Dist.CLIENT)
public class RemorphedScreen
extends Screen {
    private final List<ShapeType<?>> unlockedShapes = new CopyOnWriteArrayList();
    private final List<PlayerProfile> unlockedSkins = new CopyOnWriteArrayList<PlayerProfile>();
    private final Map<ShapeType<?>, Mob> renderEntities = new ConcurrentHashMap();
    private final Map<PlayerProfile, FakeClientPlayer> renderPlayers = new ConcurrentHashMap<PlayerProfile, FakeClientPlayer>();
    private final List<ShapeWidget> shapeWidgets = new CopyOnWriteArrayList<ShapeWidget>();
    private final SearchWidget searchBar = this.createSearchBar();
    private final Button helpButton = this.createHelpButton();
    private final Button variantsButton = this.createVariantsButton();
    private final Button traitsButton = this.createTraitsButton();
    private final PlayerWidget playerButton = this.createPlayerButton();
    private final SpecialShapeWidget specialShapeButton = this.createSpecialShapeButton();
    private String lastSearchContents = "";

    public RemorphedScreen() {
        super((Component)TComponent.literal((String)""));
        super.init(Minecraft.getInstance(), Minecraft.getInstance().getWindow().getGuiScaledWidth(), Minecraft.getInstance().getWindow().getGuiScaledHeight());
    }

    public void init() {
        if (this.minecraft == null) {
            return;
        }
        if (this.minecraft.player == null) {
            this.onClose();
            return;
        }
        this.addRenderableWidget((GuiEventListener)this.searchBar);
        this.addRenderableWidget((GuiEventListener)this.helpButton);
        this.addRenderableWidget((GuiEventListener)this.variantsButton);
        this.addRenderableWidget((GuiEventListener)this.traitsButton);
        this.addRenderableWidget((GuiEventListener)this.playerButton);
        if (Walkers.hasSpecialShape((UUID)this.minecraft.player.getUUID())) {
            this.addRenderableWidget((GuiEventListener)this.specialShapeButton);
        }
        if (Remorphed.CONFIG.loadMenuAsynchronous) {
            CompletableFuture.runAsync(this::instantiate);
        } else {
            this.instantiate();
        }
    }

    private void instantiate() {
        this.populateUnlockedRenderEntities((Player)this.minecraft.player);
        ShapeType currentShape = ShapeType.from((LivingEntity)PlayerShape.getCurrentShape((Player)this.minecraft.player));
        this.unlockedShapes.sort((first, second) -> {
            boolean secondIsFav;
            if (Objects.equals(first, currentShape)) {
                return -1;
            }
            if (Objects.equals(second, currentShape)) {
                return 1;
            }
            boolean firstIsFav = PlayerMorph.getFavoriteShapes((Player)this.minecraft.player).contains(first);
            if (firstIsFav == (secondIsFav = PlayerMorph.getFavoriteShapes((Player)this.minecraft.player).contains(second))) {
                return 0;
            }
            if (firstIsFav) {
                return -1;
            }
            return 1;
        });
        if (!Remorphed.displayVariantsInMenu) {
            ArrayList newUnlocked = new ArrayList();
            for (ShapeType<?> shapeType : this.unlockedShapes) {
                if (!shapeType.equals((Object)currentShape) && newUnlocked.stream().map(ShapeType::getEntityType).toList().contains(shapeType.getEntityType())) continue;
                newUnlocked.add(shapeType);
            }
            this.unlockedShapes.clear();
            this.unlockedShapes.addAll(newUnlocked);
        }
        if (Remorphed.foundSkinShifter) {
            this.populateUnlockedRenderPlayers((Player)this.minecraft.player);
            UUID currentSkin = SkinShifter.getCurrentSkin((Player)this.minecraft.player);
            this.unlockedSkins.sort((first, second) -> {
                boolean secondIsFav;
                if (Objects.equals(first.id(), currentSkin) && currentShape != null) {
                    return -1;
                }
                if (Objects.equals(second.id(), currentSkin) && currentShape != null) {
                    return 1;
                }
                boolean firstIsFav = PlayerMorph.getFavoriteSkinIds((Player)this.minecraft.player).contains(first.id());
                if (firstIsFav == (secondIsFav = PlayerMorph.getFavoriteSkinIds((Player)this.minecraft.player).contains(second.id()))) {
                    return first.name().compareTo(second.name());
                }
                if (firstIsFav) {
                    return -1;
                }
                return 1;
            });
        }
        this.populateShapeWidgets(this.unlockedShapes, this.unlockedSkins);
        this.searchBar.setResponder(text -> {
            this.setFocused((GuiEventListener)this.searchBar);
            if (!this.lastSearchContents.equals(text)) {
                ((ScreenAccessor)((Object)this)).getSelectables().removeIf(button -> button instanceof EntityWidget);
                this.children().removeIf(button -> button instanceof EntityWidget);
                List<ShapeType<?>> filteredShapes = this.unlockedShapes.stream().filter(type -> text.isEmpty() || ShapeType.createTooltipText((LivingEntity)this.renderEntities.get(type)).getString().toUpperCase().contains(text.toUpperCase()) || EntityType.getKey((EntityType)type.getEntityType()).toString().toUpperCase().contains(text.toUpperCase())).toList();
                List<PlayerProfile> filteredSkins = this.unlockedSkins.stream().filter(skin -> text.isEmpty() || skin.name().toUpperCase().contains(text.toUpperCase()) || skin.id().toString().contains(text.toUpperCase())).toList();
                this.populateShapeWidgets(filteredShapes, filteredSkins);
            }
            this.lastSearchContents = text;
        });
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderTransparentBackground(context);
        this.searchBar.render(context, mouseX, mouseY, delta);
        this.helpButton.render(context, mouseX, mouseY, delta);
        this.variantsButton.render(context, mouseX, mouseY, delta);
        this.traitsButton.render(context, mouseX, mouseY, delta);
        this.playerButton.render(context, mouseX, mouseY, delta);
        if (Walkers.hasSpecialShape((UUID)this.minecraft.player.getUUID())) {
            this.specialShapeButton.render(context, mouseX, mouseY, delta);
        }
        double scaledFactor = this.minecraft.getWindow().getGuiScale();
        int top = 35;
        context.pose().pushPose();
        RenderSystem.enableScissor((int)((int)(0.0 * scaledFactor)), (int)((int)(0.0 * scaledFactor)), (int)((int)((double)this.width * scaledFactor)), (int)((int)((double)(this.height - top) * scaledFactor)));
        for (ShapeWidget widget : this.shapeWidgets) {
            if (widget.getY() + widget.getHeight() <= top || widget.getY() >= this.getWindow().getGuiScaledHeight()) continue;
            widget.render(context, mouseX, mouseY, delta);
        }
        RenderSystem.disableScissor();
        context.pose().popPose();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.shapeWidgets.isEmpty()) {
            float firstPos = this.shapeWidgets.get(0).getY();
            ShapeWidget lastWidget = this.shapeWidgets.get(this.shapeWidgets.size() - 1);
            if (scrollY >= 0.0 && firstPos >= 35.0f || scrollY <= 0.0 && lastWidget.getY() <= this.getWindow().getGuiScaledHeight() - lastWidget.getHeight()) {
                return false;
            }
            for (NarratableEntry button : ((ScreenAccessor)((Object)this)).getSelectables()) {
                if (!(button instanceof ShapeWidget)) continue;
                ShapeWidget widget = (ShapeWidget)button;
                widget.setPosition(widget.getX(), (int)((double)widget.getY() + scrollY * 10.0));
            }
        }
        return false;
    }

    private void populateShapeWidgets(List<ShapeType<?>> rendered, List<PlayerProfile> skinProfiles) {
        this.shapeWidgets.clear();
        int x = 15;
        int y = 35;
        int rows = (int)Math.ceil((float)(rendered.size() + skinProfiles.size()) / 7.0f);
        ShapeType currentType = ShapeType.from((LivingEntity)PlayerShape.getCurrentShape((Player)this.minecraft.player));
        for (int yIndex = 0; yIndex <= rows; ++yIndex) {
            for (int xIndex = 0; xIndex < 7; ++xIndex) {
                int listIndex = yIndex * 7 + xIndex;
                if (Remorphed.foundSkinShifter && listIndex < skinProfiles.size()) {
                    PlayerProfile skinProfile = skinProfiles.get(listIndex);
                    FakeClientPlayer fakePlayer = this.renderPlayers.get(skinProfile);
                    if (fakePlayer != null) {
                        SkinWidget skinWidget = new SkinWidget((float)(this.getWindow().getGuiScaledWidth() - 27) / 7.0f * (float)xIndex + (float)x, (float)this.getWindow().getGuiScaledHeight() / 5.0f * (float)yIndex + (float)y, (float)(this.getWindow().getGuiScaledWidth() - 27) / 7.0f, (float)this.getWindow().getGuiScaledHeight() / 5.0f, skinProfile, new FakeClientPlayer(this.minecraft.level, skinProfile), this, PlayerMorph.getFavoriteSkins((Player)this.minecraft.player).contains(skinProfile), Objects.equals(SkinShifter.getCurrentSkin((Player)this.minecraft.player), skinProfile.id()) && currentType == null);
                        this.addRenderableWidget((GuiEventListener)skinWidget);
                        this.shapeWidgets.add(skinWidget);
                        continue;
                    }
                    Remorphed.LOGGER.error("invalid skin profile: {}", (Object)skinProfile);
                    continue;
                }
                if (listIndex >= skinProfiles.size() + rendered.size()) continue;
                ShapeType<?> type = rendered.get(listIndex - skinProfiles.size());
                Mob entity = this.renderEntities.get(type);
                if (entity != null) {
                    EntityWidget<Mob> entityWidget = new EntityWidget<Mob>((float)(this.getWindow().getGuiScaledWidth() - 27) / 7.0f * (float)xIndex + (float)x, (float)this.getWindow().getGuiScaledHeight() / 5.0f * (float)yIndex + (float)y, (float)(this.getWindow().getGuiScaledWidth() - 27) / 7.0f, (float)this.getWindow().getGuiScaledHeight() / 5.0f, type, entity, this, PlayerMorph.getFavoriteShapes((Player)this.minecraft.player).contains(type), type.equals((Object)currentType));
                    this.addRenderableWidget((GuiEventListener)entityWidget);
                    this.shapeWidgets.add(entityWidget);
                    continue;
                }
                Remorphed.LOGGER.error("invalid shape type: {}", (Object)type.getEntityType().getDescriptionId());
            }
        }
    }

    public synchronized void populateUnlockedRenderEntities(Player player) {
        this.unlockedShapes.clear();
        this.renderEntities.clear();
        List<ShapeType<?>> validUnlocked = Remorphed.getUnlockedShapes(player);
        for (ShapeType<?> type : validUnlocked) {
            LivingEntity entity = type.create((Level)Minecraft.getInstance().level);
            if (!(entity instanceof Mob)) continue;
            Mob living = (Mob)entity;
            this.unlockedShapes.add(type);
            this.renderEntities.put(type, living);
        }
        Remorphed.LOGGER.info("Loaded {} entities for rendering", (Object)this.unlockedShapes.size());
    }

    public synchronized void populateUnlockedRenderPlayers(Player player) {
        this.unlockedSkins.clear();
        this.renderPlayers.clear();
        List<PlayerProfile> validUnlocked = Remorphed.getUnlockedSkins(player);
        for (PlayerProfile profile : validUnlocked) {
            if (profile.id() == player.getUUID()) continue;
            FakeClientPlayer entity = new FakeClientPlayer(this.minecraft.level, profile);
            this.unlockedSkins.add(profile);
            this.renderPlayers.put(profile, entity);
        }
        Remorphed.LOGGER.info("Loaded {} players for rendering", (Object)this.unlockedSkins.size());
    }

    private SearchWidget createSearchBar() {
        return new SearchWidget((float)this.getWindow().getGuiScaledWidth() / 2.0f - (float)this.getWindow().getGuiScaledWidth() / 4.0f / 2.0f - 5.0f, 5.0f, (float)this.getWindow().getGuiScaledWidth() / 4.0f, 20.0f);
    }

    private Button createHelpButton() {
        Button.Builder helpButton = Button.builder((Component)Component.nullToEmpty((String)"?"), widget -> Minecraft.getInstance().setScreen((Screen)new RemorphedHelpScreen()));
        int xOffset = Walkers.hasSpecialShape((UUID)Minecraft.getInstance().player.getUUID()) ? 30 : 0;
        helpButton.pos((int)((float)this.getWindow().getGuiScaledWidth() / 2.0f + (float)this.getWindow().getGuiScaledWidth() / 8.0f + 35.0f + (float)xOffset), 5);
        helpButton.size(20, 20);
        helpButton.tooltip(Tooltip.create((Component)Component.translatable((String)"remorphed.help")));
        return helpButton.build();
    }

    private Button createVariantsButton() {
        Button.Builder variantsButton = Button.builder((Component)Component.translatable((String)"remorphed.display_variants"), widget -> {
            Remorphed.displayVariantsInMenu = !Remorphed.displayVariantsInMenu;
            Minecraft.getInstance().setScreen((Screen)new RemorphedScreen());
        });
        variantsButton.pos((int)((float)this.getWindow().getGuiScaledWidth() / 2.0f - (float)this.getWindow().getGuiScaledWidth() / 4.0f / 2.0f - 110.0f), 5);
        variantsButton.size(100, 20);
        variantsButton.tooltip(Tooltip.create((Component)Component.translatable((String)"remorphed.variants")));
        return variantsButton.build();
    }

    private Button createTraitsButton() {
        Button.Builder traitButton = Button.builder((Component)Component.translatable((String)"remorphed.show_traits"), widget -> {
            Remorphed.displayTraitsInMenu = !Remorphed.displayTraitsInMenu;
        });
        int xOffset = Walkers.hasSpecialShape((UUID)Minecraft.getInstance().player.getUUID()) ? 30 : 0;
        int xPos = (int)((float)this.getWindow().getGuiScaledWidth() / 2.0f + (float)this.getWindow().getGuiScaledWidth() / 8.0f + 65.0f + (float)xOffset);
        traitButton.pos(xPos, 5);
        traitButton.size(Math.min(50, this.getWindow().getGuiScaledWidth() - xPos), 20);
        traitButton.tooltip(Tooltip.create((Component)Component.translatable((String)"remorphed.traits")));
        return traitButton.build();
    }

    private PlayerWidget createPlayerButton() {
        return new PlayerWidget((int)((float)this.getWindow().getGuiScaledWidth() / 2.0f + (float)this.getWindow().getGuiScaledWidth() / 8.0f + 5.0f), 5, 20, 20, this);
    }

    private SpecialShapeWidget createSpecialShapeButton() {
        return new SpecialShapeWidget((int)((float)this.getWindow().getGuiScaledWidth() / 2.0f + (float)this.getWindow().getGuiScaledWidth() / 8.0f + 35.0f), 5, 20, 20, this);
    }

    private Window getWindow() {
        return Minecraft.getInstance().getWindow();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseY < 35.0) {
            return this.searchBar.mouseClicked(mouseX, mouseY, button) || this.helpButton.mouseClicked(mouseX, mouseY, button) || this.variantsButton.mouseClicked(mouseX, mouseY, button) || this.traitsButton.mouseClicked(mouseX, mouseY, button) || this.playerButton.mouseClicked(mouseX, mouseY, button) || this.specialShapeButton.mouseClicked(mouseX, mouseY, button);
        }
        for (ShapeWidget shapeWidget : this.shapeWidgets) {
            if (!shapeWidget.mouseClicked(mouseX, mouseY, button)) continue;
            this.setFocused((GuiEventListener)shapeWidget);
            return true;
        }
        return false;
    }
}

