/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.network;

import dev.tocraft.skinshifter.SkinShifter;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.PlayerProfile;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

public class NetworkHandler {
    public static final ResourceLocation MORPH_REQUEST = Remorphed.id("morph_request");
    public static final ResourceLocation UNLOCKED_SYNC = Remorphed.id("unlocked_sync");
    public static final ResourceLocation FAVORITE_SYNC = Remorphed.id("favorite_sync");
    public static final ResourceLocation FAVORITE_UPDATE = Remorphed.id("favorite_update");
    public static final ResourceLocation RESET_SKIN = Remorphed.id("reset_skin");

    public static void registerPacketReceiver() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)MORPH_REQUEST, NetworkHandler::handleMorphRequestPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)FAVORITE_UPDATE, NetworkHandler::handleFavoriteRequestPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)RESET_SKIN, NetworkHandler::handleResetSkinPacket);
        ModernNetworking.registerType((ResourceLocation)UNLOCKED_SYNC);
        ModernNetworking.registerType((ResourceLocation)FAVORITE_SYNC);
    }

    private static void handleResetSkinPacket(ModernNetworking.Context context, CompoundTag data) {
        if (Remorphed.foundSkinShifter) {
            SkinShifter.setSkin((ServerPlayer)((ServerPlayer)context.getPlayer()), null);
        }
    }

    public static void sendResetSkinPacket() {
        ModernNetworking.sendToServer((ResourceLocation)RESET_SKIN, (CompoundTag)new CompoundTag());
    }

    public static <T extends LivingEntity> void sendSwap2ndShapeRequest(@NotNull ShapeType<T> type) {
        CompoundTag compound = new CompoundTag();
        compound.putString("id", Walkers.getEntityTypeRegistry().getKey((Object)type.getEntityType()).toString());
        compound.putInt("variant", type.getVariantData());
        ModernNetworking.sendToServer((ResourceLocation)MORPH_REQUEST, (CompoundTag)compound);
    }

    public static <T extends LivingEntity> void sendSwapSkinRequest(@NotNull PlayerProfile playerProfile) {
        CompoundTag compound = new CompoundTag();
        compound.putUUID("playerUUID", playerProfile.id());
        ModernNetworking.sendToServer((ResourceLocation)MORPH_REQUEST, (CompoundTag)compound);
    }

    private static void handleMorphRequestPacket(ModernNetworking.Context context, CompoundTag compound) {
        context.getPlayer().getServer().execute(() -> {
            if (Walkers.CONFIG.playerUUIDBlacklist.contains(context.getPlayer().getUUID())) {
                context.getPlayer().displayClientMessage((Component)TComponent.translatable((String)"walkers.player_blacklisted", (Object[])new Object[0]), true);
                return;
            }
            if (compound.contains("playerUUID") && Remorphed.foundSkinShifter) {
                UUID targetSkinUUID = compound.getUUID("playerUUID");
                SkinShifter.setSkin((ServerPlayer)((ServerPlayer)context.getPlayer()), (UUID)targetSkinUUID);
            } else {
                ResourceLocation typeId = Identifier.parse((String)compound.getString("id"));
                int typeVariant = compound.getInt("variant");
                EntityType eType = (EntityType)Walkers.getEntityTypeRegistry().get(typeId);
                @Nullable ShapeType type = ShapeType.from((EntityType)eType, (int)typeVariant);
                boolean result = PlayerShapeChanger.change2ndShape((ServerPlayer)((ServerPlayer)context.getPlayer()), (ShapeType)type);
                if (result && type != null) {
                    PlayerShape.updateShapes((ServerPlayer)((ServerPlayer)context.getPlayer()), (LivingEntity)type.create(CEntity.level((Entity)context.getPlayer())));
                }
                context.getPlayer().refreshDimensions();
            }
        });
    }

    public static void sendFavoriteSync(ServerPlayer player) {
        Set<ShapeType<?>> favoriteShapes = PlayerMorph.getFavoriteShapes((Player)player);
        Set<UUID> favoriteSkins = PlayerMorph.getFavoriteSkinIds((Player)player);
        CompoundTag tag = new CompoundTag();
        ListTag shapeIdList = new ListTag();
        ListTag skinIdList = new ListTag();
        favoriteShapes.forEach(type -> shapeIdList.add((Object)type.writeCompound()));
        favoriteSkins.forEach(skin -> skinIdList.add((Object)NbtUtils.createUUID((UUID)skin)));
        tag.put("FavoriteShapes", (Tag)shapeIdList);
        tag.put("FavoriteSkins", (Tag)skinIdList);
        ModernNetworking.sendToPlayer((ServerPlayer)player, (ResourceLocation)FAVORITE_SYNC, (CompoundTag)tag);
    }

    public static void sendFavoriteRequest(ShapeType<? extends LivingEntity> type, boolean favorite) {
        CompoundTag packet = new CompoundTag();
        packet.putString("id", Walkers.getEntityTypeRegistry().getKey((Object)type.getEntityType()).toString());
        packet.putInt("variant", type.getVariantData());
        packet.putBoolean("favorite", favorite);
        ModernNetworking.sendToServer((ResourceLocation)FAVORITE_UPDATE, (CompoundTag)packet);
    }

    public static void sendFavoriteRequest(PlayerProfile playerProfile, boolean favorite) {
        CompoundTag packet = new CompoundTag();
        packet.putUUID("playerUUID", playerProfile.id());
        packet.putBoolean("favorite", favorite);
        ModernNetworking.sendToServer((ResourceLocation)FAVORITE_UPDATE, (CompoundTag)packet);
    }

    private static void handleFavoriteRequestPacket(ModernNetworking.Context context, CompoundTag packet) {
        boolean favorite = packet.getBoolean("favorite");
        if (packet.contains("playerUUID")) {
            UUID skinId = packet.getUUID("playerUUID");
            context.getPlayer().getServer().execute(() -> {
                if (favorite) {
                    PlayerMorph.getFavoriteSkinIds(context.getPlayer()).add(skinId);
                } else {
                    PlayerMorph.getFavoriteSkinIds(context.getPlayer()).remove(skinId);
                }
                NetworkHandler.sendFavoriteSync((ServerPlayer)context.getPlayer());
            });
        } else {
            EntityType entityType = (EntityType)Walkers.getEntityTypeRegistry().get(Identifier.parse((String)packet.getString("id")));
            int variant = packet.getInt("variant");
            context.getPlayer().getServer().execute(() -> {
                @Nullable ShapeType type = ShapeType.from((EntityType)entityType, (int)variant);
                if (type != null) {
                    if (favorite) {
                        PlayerMorph.getFavoriteShapes(context.getPlayer()).add(type);
                    } else {
                        PlayerMorph.getFavoriteShapes(context.getPlayer()).remove(type);
                    }
                    NetworkHandler.sendFavoriteSync((ServerPlayer)context.getPlayer());
                }
            });
        }
    }
}

