/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.network;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.client.CraftedCoreClient;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.network.client.ClientNetworking;
import tocraft.craftedcore.patched.Identifier;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.variant.ShapeType;

@OnlyIn(value=Dist.CLIENT)
public class ClientNetworking {
    public static void registerPacketHandlers() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (ResourceLocation)NetworkHandler.UNLOCKED_SYNC, ClientNetworking::handleUnlockedSyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (ResourceLocation)NetworkHandler.FAVORITE_SYNC, ClientNetworking::handleFavoriteSyncPacket);
    }

    public static void handleUnlockedSyncPacket(ModernNetworking.Context context, CompoundTag compound) {
        UUID uuid = compound.getUUID("uuid");
        HashMap unlockedShapes = new HashMap();
        if (compound.contains("UnlockedShapes")) {
            compound.getList("UnlockedShapes", 10).forEach(entryTag -> {
                EntityType eType = (EntityType)Walkers.getEntityTypeRegistry().get(Identifier.parse((String)((CompoundTag)entryTag).getString("id")));
                int variant = ((CompoundTag)entryTag).getInt("variant");
                int killAmount = ((CompoundTag)entryTag).getInt("killAmount");
                unlockedShapes.put(ShapeType.from((EntityType)eType, (int)variant), killAmount);
            });
        }
        HashMap unlockedSkins = new HashMap();
        if (compound.contains("UnlockedSkins")) {
            compound.getList("UnlockedSkins", 10).forEach(entryTag -> {
                UUID unlockedSkinUUID = ((CompoundTag)entryTag).getUUID("uuid");
                int killAmount = ((CompoundTag)entryTag).getInt("killAmount");
                unlockedSkins.put(unlockedSkinUUID, killAmount);
            });
        }
        ClientNetworking.runOrQueue(context, player -> {
            @Nullable Player syncTarget = player.getCommandSenderWorld().getPlayerByUUID(uuid);
            if (syncTarget != null) {
                PlayerMorph.getUnlockedShapes(player).clear();
                PlayerMorph.getUnlockedShapes(player).putAll(unlockedShapes);
                PlayerMorph.getUnlockedSkinIds(player).clear();
                PlayerMorph.getUnlockedSkinIds(player).putAll(unlockedSkins);
            }
        });
    }

    private static void handleFavoriteSyncPacket(ModernNetworking.Context context, CompoundTag tag) {
        ClientNetworking.runOrQueue(context, player -> {
            PlayerMorph.getFavoriteShapes(player).clear();
            PlayerMorph.getFavoriteSkinIds(player).clear();
            ListTag shapeIds = tag.getList("FavoriteShapes", 10);
            ListTag skinIds = tag.getList("FavoriteSkins", 11);
            shapeIds.forEach(compound -> PlayerMorph.getFavoriteShapes(player).add(ShapeType.from((CompoundTag)((CompoundTag)compound))));
            skinIds.forEach(skinId -> PlayerMorph.getFavoriteSkinIds(player).add(NbtUtils.loadUUID((Tag)skinId)));
        });
    }

    public static void runOrQueue(ModernNetworking.Context context, ClientNetworking.ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            CraftedCoreClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }
}

