/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.mixin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.Identifier;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.variant.ShapeType;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements RemorphedPlayerDataProvider {
    @Unique
    private final Map<ShapeType<? extends LivingEntity>, Integer> remorphed$unlockedShapes = new HashMap<ShapeType<? extends LivingEntity>, Integer>();
    @Unique
    private final Set<ShapeType<?>> remorphed$favoriteShapes = new HashSet();
    @Unique
    private final Map<UUID, Integer> remorphed$unlockedSkins = new ConcurrentHashMap<UUID, Integer>();
    @Unique
    private final Set<UUID> remorphed$favoriteSkins = new CopyOnWriteArraySet<UUID>();
    @Unique
    private final String UNLOCKED_SHAPES = "UnlockedShapes";
    @Unique
    private final String FAVORITE_SHAPES = "FavoriteShapes";
    @Unique
    private final String UNLOCKED_SKINS = "UnlockedSkins";
    @Unique
    private final String FAVORITE_SKINS = "FavoriteSkins";

    private PlayerEntityMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void serverTick(CallbackInfo info) {
        if (!CEntity.level((Entity)this).isClientSide) {
            Remorphed.sync((ServerPlayer)this);
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    private void readNbt(CompoundTag tag, CallbackInfo info) {
        this.remorphed$readData(tag.getCompound("remorphed"));
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    private void writeNbt(CompoundTag tag, CallbackInfo info) {
        tag.put("remorphed", (Tag)this.remorphed$writeData());
    }

    @Unique
    private CompoundTag remorphed$writeData() {
        CompoundTag tag = new CompoundTag();
        ListTag unlockedShapes = new ListTag();
        this.remorphed$unlockedShapes.forEach((shape, killAmount) -> {
            if (killAmount > 0 && shape != null) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putString("id", Walkers.getEntityTypeRegistry().getKey((Object)shape.getEntityType()).toString());
                entryTag.putInt("variant", shape.getVariantData());
                entryTag.putInt("killAmount", killAmount.intValue());
                unlockedShapes.add((Object)entryTag);
            }
        });
        if (!unlockedShapes.isEmpty()) {
            tag.put("UnlockedShapes", (Tag)unlockedShapes);
        }
        ListTag favoriteShapes = new ListTag();
        this.remorphed$favoriteShapes.forEach(shape -> {
            if (shape != null) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putString("id", Walkers.getEntityTypeRegistry().getKey((Object)shape.getEntityType()).toString());
                entryTag.putInt("variant", shape.getVariantData());
                favoriteShapes.add((Object)entryTag);
            }
        });
        if (!favoriteShapes.isEmpty()) {
            tag.put("FavoriteShapes", (Tag)favoriteShapes);
        }
        ListTag unlockedSkins = new ListTag();
        this.remorphed$unlockedSkins.forEach((skinId, killAmount) -> {
            if (killAmount > 0 && skinId != null) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putUUID("uuid", skinId);
                entryTag.putInt("killAmount", killAmount.intValue());
                unlockedSkins.add((Object)entryTag);
            }
        });
        if (!unlockedSkins.isEmpty()) {
            tag.put("UnlockedSkins", (Tag)unlockedSkins);
        }
        ListTag favoriteSkins = new ListTag();
        this.remorphed$favoriteSkins.forEach(skinId -> {
            if (skinId != null) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putUUID("uuid", skinId);
                favoriteSkins.add((Object)entryTag);
            }
        });
        if (!favoriteSkins.isEmpty()) {
            tag.put("FavoriteSkins", (Tag)favoriteSkins);
        }
        return tag;
    }

    @Unique
    public void remorphed$readData(CompoundTag tag) {
        this.remorphed$unlockedShapes.clear();
        this.remorphed$favoriteShapes.clear();
        this.remorphed$unlockedSkins.clear();
        this.remorphed$favoriteSkins.clear();
        ListTag unlockedShapes = tag.getList("UnlockedShapes", 10);
        unlockedShapes.forEach(entry -> {
            if (entry instanceof CompoundTag) {
                ResourceLocation typeId = Identifier.parse((String)((CompoundTag)entry).getString("id"));
                int typeVariantId = ((CompoundTag)entry).getInt("variant");
                int killAmount = ((CompoundTag)entry).getInt("killAmount");
                this.remorphed$unlockedShapes.put((ShapeType<? extends LivingEntity>)ShapeType.from((EntityType)((EntityType)Walkers.getEntityTypeRegistry().get(typeId)), (int)typeVariantId), killAmount);
            }
        });
        ListTag favoriteShapes = tag.getList("FavoriteShapes", 10);
        favoriteShapes.forEach(entry -> {
            if (entry instanceof CompoundTag) {
                ResourceLocation typeId = Identifier.parse((String)((CompoundTag)entry).getString("id"));
                int typeVariantId = ((CompoundTag)entry).getInt("variant");
                this.remorphed$favoriteShapes.add(ShapeType.from((EntityType)((EntityType)Walkers.getEntityTypeRegistry().get(typeId)), (int)typeVariantId));
            }
        });
        ListTag unlockedSkins = tag.getList("UnlockedSkins", 10);
        unlockedSkins.forEach(entry -> {
            if (entry instanceof CompoundTag) {
                UUID skinId = ((CompoundTag)entry).getUUID("uuid");
                int killAmount = ((CompoundTag)entry).getInt("killAmount");
                this.remorphed$unlockedSkins.put(skinId, killAmount);
            }
        });
        ListTag favoriteSkins = tag.getList("FavoriteSkins", 10);
        favoriteSkins.forEach(entry -> {
            if (entry instanceof CompoundTag) {
                UUID skinId = ((CompoundTag)entry).getUUID("uuid");
                this.remorphed$favoriteSkins.add(skinId);
            }
        });
    }

    @Override
    @Unique
    public Map<ShapeType<? extends LivingEntity>, Integer> remorphed$getUnlockedShapes() {
        return this.remorphed$unlockedShapes;
    }

    @Override
    @Unique
    public void remorphed$addKill(ShapeType<? extends LivingEntity> type) {
        this.remorphed$unlockedShapes.put(type, this.remorphed$getKills(type) + 1);
    }

    @Override
    @Unique
    public int remorphed$getKills(ShapeType<? extends LivingEntity> type) {
        if (Walkers.CONFIG.unlockEveryVariant) {
            int killAmount = 0;
            for (Integer i : this.remorphed$unlockedShapes.entrySet().stream().filter(entry -> ((ShapeType)entry.getKey()).getEntityType().equals(type.getEntityType())).map(Map.Entry::getValue).toList()) {
                killAmount += i.intValue();
            }
            return killAmount;
        }
        return this.remorphed$unlockedShapes.getOrDefault(type, 0);
    }

    @Override
    @Unique
    public Set<ShapeType<?>> remorphed$getFavoriteShapes() {
        return this.remorphed$favoriteShapes;
    }

    @Override
    @Unique
    public Map<UUID, Integer> remorphed$getUnlockedSkins() {
        return this.remorphed$unlockedSkins;
    }

    @Override
    @Unique
    public void remorphed$addKill(UUID skinId) {
        this.remorphed$unlockedSkins.put(skinId, this.remorphed$getKills(skinId) + 1);
    }

    @Override
    @Unique
    public int remorphed$getKills(UUID skinId) {
        return this.remorphed$unlockedSkins.getOrDefault(skinId, 0);
    }

    @Override
    @Unique
    public Set<UUID> remorphed$getFavoriteSkins() {
        return this.remorphed$favoriteSkins;
    }
}

