/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.tocraft.skinshifter.SkinShifter;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.common.CommandEvents;
import tocraft.craftedcore.patched.CCommandSourceStack;
import tocraft.craftedcore.patched.CEntitySummonArgument;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.PlayerProfile;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

public class RemorphedCommand
implements CommandEvents.CommandRegistration {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registry, Commands.CommandSelection selection) {
        LiteralCommandNode rootNode = ((LiteralArgumentBuilder)Commands.literal((String)"remorphed").requires(source -> source.hasPermission(2))).build();
        LiteralCommandNode removeShape = ((LiteralArgumentBuilder)Commands.literal((String)"removeShape").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"shape", (ArgumentType)CEntitySummonArgument.id((CommandBuildContext)registry)).suggests(SuggestionProviders.SUMMONABLE_ENTITIES).executes(context -> {
            RemorphedCommand.removeShape((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), null);
            return 1;
        })).then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> {
            CompoundTag nbt = CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"nbt");
            RemorphedCommand.removeShape((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), nbt);
            return 1;
        }))))).build();
        LiteralCommandNode addShape = ((LiteralArgumentBuilder)Commands.literal((String)"addShape").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"shape", (ArgumentType)CEntitySummonArgument.id((CommandBuildContext)registry)).suggests(SuggestionProviders.SUMMONABLE_ENTITIES).executes(context -> {
            RemorphedCommand.addShape((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), null);
            return 1;
        })).then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> {
            CompoundTag nbt = CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"nbt");
            RemorphedCommand.addShape((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), nbt);
            return 1;
        }))))).build();
        LiteralCommandNode clearShapes = ((LiteralArgumentBuilder)Commands.literal((String)"clearShapes").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).executes(context -> {
            RemorphedCommand.clearShapes((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"));
            return 1;
        }))).build();
        LiteralCommandNode hasShape = ((LiteralArgumentBuilder)Commands.literal((String)"hasShape").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"shape", (ArgumentType)CEntitySummonArgument.id((CommandBuildContext)registry)).suggests(SuggestionProviders.SUMMONABLE_ENTITIES).executes(context -> RemorphedCommand.hasShape((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), null))).then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> {
            CompoundTag nbt = CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"nbt");
            return RemorphedCommand.hasShape((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), nbt);
        }))))).build();
        LiteralCommandNode removeSkin = ((LiteralArgumentBuilder)Commands.literal((String)"removeSkin").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"playerUUID", (ArgumentType)UuidArgument.uuid()).executes(context -> {
            UUID playerUUID = UuidArgument.getUuid((CommandContext)context, (String)"playerUUID");
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            CompletableFuture.runAsync(() -> {
                PlayerProfile playerProfile = PlayerProfile.ofId((UUID)playerUUID);
                if (playerProfile == null) {
                    CCommandSourceStack.sendSuccess((CommandSourceStack)((CommandSourceStack)context.getSource()), (Component)TComponent.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerUUID}), (boolean)true);
                } else {
                    RemorphedCommand.removeSkin((CommandSourceStack)context.getSource(), player, playerProfile);
                }
            });
            return 1;
        }))).then(Commands.argument((String)"playerName", (ArgumentType)MessageArgument.message()).executes(context -> {
            String playerName = MessageArgument.getMessage((CommandContext)context, (String)"playerName").getString();
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            CompletableFuture.runAsync(() -> {
                PlayerProfile playerProfile = PlayerProfile.ofName((String)playerName);
                if (playerProfile == null) {
                    CCommandSourceStack.sendSuccess((CommandSourceStack)((CommandSourceStack)context.getSource()), (Component)TComponent.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerName}), (boolean)true);
                } else {
                    RemorphedCommand.removeSkin((CommandSourceStack)context.getSource(), player, playerProfile);
                }
            });
            return 1;
        })))).build();
        LiteralCommandNode addSkin = ((LiteralArgumentBuilder)Commands.literal((String)"addSkin").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"playerUUID", (ArgumentType)UuidArgument.uuid()).executes(context -> {
            UUID playerUUID = UuidArgument.getUuid((CommandContext)context, (String)"playerUUID");
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            CompletableFuture.runAsync(() -> {
                PlayerProfile playerProfile = PlayerProfile.ofId((UUID)playerUUID);
                if (playerProfile == null) {
                    CCommandSourceStack.sendSuccess((CommandSourceStack)((CommandSourceStack)context.getSource()), (Component)TComponent.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerUUID}), (boolean)true);
                } else {
                    RemorphedCommand.addSkin((CommandSourceStack)context.getSource(), player, playerProfile);
                }
            });
            return 1;
        }))).then(Commands.argument((String)"playerName", (ArgumentType)MessageArgument.message()).executes(context -> {
            String playerName = MessageArgument.getMessage((CommandContext)context, (String)"playerName").getString();
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            CompletableFuture.runAsync(() -> {
                PlayerProfile playerProfile = PlayerProfile.ofName((String)playerName);
                if (playerProfile == null) {
                    CCommandSourceStack.sendSuccess((CommandSourceStack)((CommandSourceStack)context.getSource()), (Component)TComponent.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerName}), (boolean)true);
                } else {
                    RemorphedCommand.addSkin((CommandSourceStack)context.getSource(), player, playerProfile);
                }
            });
            return 1;
        })))).build();
        LiteralCommandNode clearSkins = ((LiteralArgumentBuilder)Commands.literal((String)"clearSkins").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).executes(context -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            RemorphedCommand.clearSkins((CommandSourceStack)context.getSource(), player);
            return 1;
        }))).build();
        LiteralCommandNode hasSkin = ((LiteralArgumentBuilder)Commands.literal((String)"hasSkin").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"playerUUID", (ArgumentType)UuidArgument.uuid()).executes(context -> {
            UUID playerUUID = UuidArgument.getUuid((CommandContext)context, (String)"playerUUID");
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            CompletableFuture.runAsync(() -> {
                PlayerProfile playerProfile = PlayerProfile.ofId((UUID)playerUUID);
                if (playerProfile == null) {
                    CCommandSourceStack.sendSuccess((CommandSourceStack)((CommandSourceStack)context.getSource()), (Component)TComponent.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerUUID}), (boolean)true);
                } else {
                    RemorphedCommand.hasSkin((CommandSourceStack)context.getSource(), player, playerProfile);
                }
            });
            return 1;
        }))).then(Commands.argument((String)"playerName", (ArgumentType)MessageArgument.message()).executes(context -> {
            String playerName = MessageArgument.getMessage((CommandContext)context, (String)"playerName").getString();
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            CompletableFuture.runAsync(() -> {
                PlayerProfile playerProfile = PlayerProfile.ofName((String)playerName);
                if (playerProfile == null) {
                    CCommandSourceStack.sendSuccess((CommandSourceStack)((CommandSourceStack)context.getSource()), (Component)TComponent.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerName}), (boolean)true);
                } else {
                    RemorphedCommand.hasSkin((CommandSourceStack)context.getSource(), player, playerProfile);
                }
            });
            return 1;
        })))).build();
        rootNode.addChild((CommandNode)removeShape);
        rootNode.addChild((CommandNode)addShape);
        rootNode.addChild((CommandNode)clearShapes);
        rootNode.addChild((CommandNode)hasShape);
        if (Remorphed.foundSkinShifter) {
            rootNode.addChild((CommandNode)removeSkin);
            rootNode.addChild((CommandNode)addSkin);
            rootNode.addChild((CommandNode)clearSkins);
            rootNode.addChild((CommandNode)hasSkin);
        }
        dispatcher.getRoot().addChild((CommandNode)rootNode);
    }

    private static int hasShape(CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType<LivingEntity> type = RemorphedCommand.getType(source.getLevel(), id, nbt);
        MutableComponent name = TComponent.translatable((String)type.getEntityType().getDescriptionId(), (Object[])new Object[0]);
        if (PlayerMorph.getUnlockedShapes((Player)player).containsKey(type)) {
            CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"remorphed.hasShape_success", (Object[])new Object[]{player.getDisplayName(), name}), (boolean)true);
            return 1;
        }
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"remorphed.hasShape_fail", (Object[])new Object[]{player.getDisplayName(), name}), (boolean)true);
        return 0;
    }

    private static void removeShape(CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType<LivingEntity> type = RemorphedCommand.getType(source.getLevel(), id, nbt);
        MutableComponent name = TComponent.translatable((String)type.getEntityType().getDescriptionId(), (Object[])new Object[0]);
        PlayerMorph.getUnlockedShapes((Player)player).remove(type);
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"remorphed.removeShape", (Object[])new Object[]{name, player.getDisplayName()}), (boolean)true);
    }

    private static void addShape(CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType<LivingEntity> type = RemorphedCommand.getType(source.getLevel(), id, nbt);
        MutableComponent name = TComponent.translatable((String)type.getEntityType().getDescriptionId(), (Object[])new Object[0]);
        PlayerMorph.getUnlockedShapes((Player)player).put(type, Remorphed.getKillToUnlock(type.getEntityType()));
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"remorphed.addShape", (Object[])new Object[]{player.getDisplayName(), name}), (boolean)true);
    }

    private static void clearShapes(CommandSourceStack source, ServerPlayer player) {
        PlayerMorph.getUnlockedShapes((Player)player).clear();
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"remorphed.clearShapes", (Object[])new Object[]{player.getDisplayName()}), (boolean)true);
        PlayerShapeChanger.change2ndShape((ServerPlayer)player, null);
    }

    private static ShapeType<LivingEntity> getType(ServerLevel serverLevel, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType type = ShapeType.from((EntityType)((EntityType)Walkers.getEntityTypeRegistry().get(id)));
        if (nbt != null) {
            CompoundTag copy = nbt.copy();
            copy.putString("id", id.toString());
            Entity loaded = EntityType.loadEntityRecursive((CompoundTag)copy, (Level)serverLevel, it -> it);
            if (loaded instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)loaded;
                type = new ShapeType(living);
            }
        }
        return type;
    }

    private static void hasSkin(CommandSourceStack source, ServerPlayer player, PlayerProfile playerProfile) {
        if (PlayerMorph.getUnlockedSkinIds((Player)player).containsKey(playerProfile.id())) {
            CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"remorphed.hasSkin_success", (Object[])new Object[]{player.getDisplayName(), playerProfile.name()}), (boolean)true);
        } else {
            CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"remorphed.hasSkin_fail", (Object[])new Object[]{player.getDisplayName(), playerProfile.name()}), (boolean)true);
        }
    }

    private static void removeSkin(CommandSourceStack source, ServerPlayer player, PlayerProfile playerProfile) {
        PlayerMorph.getUnlockedSkinIds((Player)player).remove(playerProfile.id());
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"remorphed.removeSkin", (Object[])new Object[]{playerProfile.name(), player.getDisplayName()}), (boolean)true);
    }

    private static void addSkin(CommandSourceStack source, ServerPlayer player, PlayerProfile playerProfile) {
        PlayerMorph.getUnlockedSkinIds((Player)player).put(playerProfile.id(), Remorphed.CONFIG.killToUnlockPlayers);
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"remorphed.addSkin", (Object[])new Object[]{player.getDisplayName(), playerProfile.name()}), (boolean)true);
    }

    private static void clearSkins(CommandSourceStack source, ServerPlayer player) {
        PlayerMorph.getUnlockedSkinIds((Player)player).clear();
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"remorphed.clearSkins", (Object[])new Object[]{player.getDisplayName()}), (boolean)true);
        if (Remorphed.foundSkinShifter) {
            SkinShifter.setSkin((ServerPlayer)player, null);
        }
    }
}

