/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tocraft.craftedcore.config.ConfigLoader;
import tocraft.craftedcore.event.common.CommandEvents;
import tocraft.craftedcore.event.common.EntityEvents;
import tocraft.craftedcore.event.common.PlayerEvents;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.craftedcore.platform.PlayerProfile;
import tocraft.craftedcore.platform.VersionChecker;
import tocraft.remorphed.RemorphedClient;
import tocraft.remorphed.command.RemorphedCommand;
import tocraft.remorphed.config.RemorphedConfig;
import tocraft.remorphed.handler.LivingDeathHandler;
import tocraft.remorphed.handler.PlayerRespawnHandler;
import tocraft.remorphed.handler.ShapeEventsCallback;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.events.ShapeEvents;
import tocraft.walkers.api.platform.ApiLevel;
import tocraft.walkers.api.variant.ShapeType;

public class Remorphed {
    public static final Logger LOGGER = LoggerFactory.getLogger(Remorphed.class);
    public static final String MODID = "remorphed";
    public static final RemorphedConfig CONFIG = (RemorphedConfig)ConfigLoader.read((String)"remorphed", RemorphedConfig.class);
    public static boolean displayVariantsInMenu = true;
    public static boolean displayTraitsInMenu = true;
    public static final boolean foundSkinShifter = PlatformData.isModLoaded((String)"skinshifter");

    public void initialize() {
        ShapeEvents.UNLOCK_SHAPE.register((Object)new ShapeEventsCallback());
        if (!Remorphed.CONFIG.unlockFriendlyNormal) {
            ApiLevel.setApiLevel((ApiLevel)ApiLevel.MORPHING_AND_VARIANTS_MENU_ONLY);
        }
        Walkers.devs.add(UUID.fromString("74b6d9b3-c8c1-40db-ab82-ccc290d1aa03"));
        VersionChecker.registerModrinthChecker((String)MODID, (String)MODID, (Component)TComponent.literal((String)"Remorphed"));
        if (PlatformData.getEnv() == Dist.CLIENT) {
            new RemorphedClient().initialize();
        }
        NetworkHandler.registerPacketReceiver();
        CommandEvents.REGISTRATION.register((Object)new RemorphedCommand());
        EntityEvents.LIVING_DEATH.register((Object)new LivingDeathHandler());
        PlayerEvents.PLAYER_RESPAWN.register((Object)new PlayerRespawnHandler());
        Walkers.CONFIG.unlockOverridesCurrentShape = Remorphed.CONFIG.unlockFriendlyNormal;
        Walkers.CONFIG.save();
        PlayerEvents.PLAYER_JOIN.register(NetworkHandler::sendFavoriteSync);
    }

    public static boolean canUseEveryShape(Player player) {
        return player.isCreative() && Remorphed.CONFIG.creativeUnlockAll;
    }

    public static boolean canUseShape(Player player, ShapeType<?> type) {
        return Remorphed.canUseEveryShape(player) || !Remorphed.CONFIG.lockTransform && (type == null || Remorphed.getKillToUnlock(type.getEntityType()) <= 0 || PlayerMorph.getKills(player, type) >= Remorphed.getKillToUnlock(type.getEntityType()));
    }

    public static List<ShapeType<?>> getUnlockedShapes(Player player) {
        if (Remorphed.canUseEveryShape(player)) {
            return ShapeType.getAllTypes((Level)CEntity.level((Entity)player));
        }
        if (Walkers.CONFIG.unlockEveryVariant) {
            ArrayList unlocked = new ArrayList();
            for (ShapeType shapeType : ShapeType.getAllTypes((Level)CEntity.level((Entity)player))) {
                if (unlocked.contains(shapeType) || !Remorphed.canUseShape(player, shapeType)) continue;
                unlocked.add(shapeType);
            }
            return unlocked;
        }
        return new ArrayList(PlayerMorph.getUnlockedShapes(player).keySet().stream().filter(type -> Remorphed.canUseShape(player, type)).toList());
    }

    public static List<PlayerProfile> getUnlockedSkins(Player player) {
        return new ArrayList<PlayerProfile>(PlayerMorph.getUnlockedSkinIds(player).keySet().stream().filter(skinId -> (PlayerMorph.getPlayerKills(player, skinId) >= Remorphed.CONFIG.killToUnlockPlayers || Remorphed.CONFIG.killToUnlockPlayers == 0) && Remorphed.CONFIG.killToUnlockPlayers != -1).map(PlayerProfile::ofId).filter(Objects::nonNull).toList());
    }

    public static int getKillToUnlock(EntityType<?> entityType) {
        String id = Walkers.getEntityTypeRegistry().getKey(entityType).toString();
        if (Remorphed.CONFIG.killToUnlockByType.containsKey(id)) {
            return Remorphed.CONFIG.killToUnlockByType.get(id);
        }
        return Remorphed.CONFIG.killToUnlock;
    }

    public static void sync(ServerPlayer player) {
        Remorphed.sync(player, player);
    }

    public static void sync(ServerPlayer changed, ServerPlayer packetTarget) {
        CompoundTag compoundTag = new CompoundTag();
        Map<ShapeType<? extends LivingEntity>, Integer> unlockedShapes = PlayerMorph.getUnlockedShapes((Player)changed);
        ListTag shapesList = new ListTag();
        unlockedShapes.forEach((shape, killAmount) -> {
            if (killAmount > 0 && shape != null) {
                CompoundTag compound = new CompoundTag();
                compound.putString("id", Walkers.getEntityTypeRegistry().getKey((Object)shape.getEntityType()).toString());
                compound.putInt("variant", shape.getVariantData());
                compound.putInt("killAmount", killAmount.intValue());
                shapesList.add((Object)compound);
            }
        });
        if (!shapesList.isEmpty()) {
            compoundTag.put("UnlockedShapes", (Tag)shapesList);
        }
        Map<UUID, Integer> unlockedSkins = PlayerMorph.getUnlockedSkinIds((Player)changed);
        ListTag skinsList = new ListTag();
        unlockedSkins.forEach((skinId, killAmount) -> {
            if (killAmount > 0 && skinId != null) {
                CompoundTag compound = new CompoundTag();
                compound.putUUID("uuid", skinId);
                compound.putInt("killAmount", killAmount.intValue());
                skinsList.add((Object)compound);
            }
        });
        if (!skinsList.isEmpty()) {
            compoundTag.put("UnlockedSkins", (Tag)skinsList);
        }
        compoundTag.putUUID("uuid", changed.getUUID());
        ModernNetworking.sendToPlayer((ServerPlayer)packetTarget, (ResourceLocation)NetworkHandler.UNLOCKED_SYNC, (CompoundTag)compoundTag);
    }

    public static ResourceLocation id(String name) {
        return Identifier.parse((String)MODID, (String)name);
    }
}

