/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.screen.hud;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.client.RenderEvents;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.AttackForHealthTrait;

public class OverlayEventHandler {
    public static void initialize() {
        RenderEvents.RENDER_FOOD.register((Object)new RenderFood());
    }

    private static class RenderFood
    implements RenderEvents.OverlayRendering {
        private RenderFood() {
        }

        public InteractionResult render(@Nullable GuiGraphics graphics, Player player) {
            LivingEntity shape;
            if (player != null && (shape = PlayerShape.getCurrentShape(player)) != null && TraitRegistry.has(shape, AttackForHealthTrait.ID)) {
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }
    }
}

