/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.network.impl;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.platform.ApiLevel;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;
import tocraft.walkers.network.ClientNetworking;
import tocraft.walkers.network.NetworkHandler;

public class SwapVariantPackets {
    public static void registerSwapVariantPacketHandler() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)NetworkHandler.VARIANT_REQUEST, (context, packet) -> {
            if (!ApiLevel.getCurrentLevel().allowVariantsMenu) {
                return;
            }
            int variantID = packet.getInt("variant_id");
            context.getPlayer().getServer().execute(() -> {
                if (Walkers.CONFIG.unlockEveryVariant) {
                    LivingEntity shape;
                    ShapeType<LivingEntity> newShapeType;
                    int range;
                    ShapeType<LivingEntity> currentShapeType = ShapeType.from(PlayerShape.getCurrentShape(context.getPlayer()));
                    TypeProvider<LivingEntity> typeProvider = TypeProviderRegistry.getProvider(currentShapeType.getEntityType());
                    int n = range = typeProvider != null ? typeProvider.getRange() : -1;
                    if (Walkers.hasSpecialShape(context.getPlayer().getUUID()) && EntityType.getKey(currentShapeType.getEntityType()).equals((Object)Identifier.parse((String)"minecraft:wolf")) && variantID == range + 1) {
                        CompoundTag nbt = new CompoundTag();
                        nbt.putBoolean("isSpecial", true);
                        nbt.putString("id", EntityType.getKey(currentShapeType.getEntityType()).toString());
                        Entity created = EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)CEntity.level((Entity)context.getPlayer()), it -> it);
                        PlayerShape.updateShapes((ServerPlayer)context.getPlayer(), (LivingEntity)created);
                    } else if (currentShapeType != null && currentShapeType.getVariantData() != variantID && (newShapeType = ShapeType.from(currentShapeType.getEntityType(), variantID)) != null && (PlayerShapeChanger.change2ndShape((ServerPlayer)context.getPlayer(), newShapeType) || !ApiLevel.getCurrentLevel().canUnlock) && (shape = newShapeType.create(CEntity.level((Entity)context.getPlayer()), context.getPlayer())) != null) {
                        PlayerShape.updateShapes((ServerPlayer)context.getPlayer(), shape);
                    }
                }
            });
        });
    }

    public static void sendSwapRequest(int variantID) {
        if (Walkers.CONFIG.unlockEveryVariant) {
            if (!ApiLevel.getCurrentLevel().allowVariantsMenu) {
                return;
            }
            CompoundTag packet = new CompoundTag();
            packet.putInt("variant_id", variantID);
            ModernNetworking.sendToServer((ResourceLocation)ClientNetworking.VARIANT_REQUEST, (CompoundTag)packet);
        }
    }
}

