/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.mixin.client.accessor.EntityShadowAccessor;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={EntityRenderDispatcher.class}, priority=999)
public abstract class ShadowMixin {
    @Unique
    private static Entity shape_shadowEntity;

    @Inject(method={"renderShadow(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/entity/Entity;FFLnet/minecraft/world/level/LevelReader;F)V"}, at={@At(value="HEAD")})
    private static void storeContext(PoseStack matrices, MultiBufferSource vertexConsumers, Entity entity, float opacity, float tickDelta, LevelReader world, float radius, CallbackInfo ci) {
        shape_shadowEntity = entity;
    }

    @ModifyVariable(method={"renderShadow(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/entity/Entity;FFLnet/minecraft/world/level/LevelReader;F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;lerp(DDD)D", ordinal=0), index=6, argsOnly=true)
    private static float adjustShadowSize(float originalSize) {
        Player player;
        LivingEntity shape;
        Entity entity = shape_shadowEntity;
        if (entity instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entity)) != null) {
            EntityRenderer r = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)shape);
            float shadowRadius = ((EntityShadowAccessor)r).getShadowRadius();
            float mod = shape.isBaby() ? 0.5f : 1.0f;
            return shadowRadius * mod;
        }
        return originalSize;
    }
}

