/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Wolf.class})
public abstract class WolfEntityMixin
extends TamableAnimal {
    @Unique
    private static final EntityDataAccessor<Boolean> walkers$isSpecial = SynchedEntityData.defineId(Wolf.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    private WolfEntityMixin(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void onTick(CallbackInfo ci) {
        if (this.hasCustomName() && this.getCustomName().getString().equalsIgnoreCase("Patreon")) {
            ((Wolf)this).getEntityData().set(walkers$isSpecial, (Object)true);
        } else {
            ((Wolf)this).getEntityData().set(walkers$isSpecial, (Object)false);
        }
    }

    @Inject(method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"}, at={@At(value="RETURN")})
    protected void onInitDataTracker(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(walkers$isSpecial, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    protected void onWriteCustomDataToNbt(CompoundTag nbt, CallbackInfo ci) {
        nbt.putBoolean("isSpecial", ((Boolean)((Wolf)this).getEntityData().get(walkers$isSpecial)).booleanValue());
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    protected void onReadCustomDataFromNbt(CompoundTag nbt, CallbackInfo ci) {
        ((Wolf)this).getEntityData().set(walkers$isSpecial, (Object)nbt.getBoolean("isSpecial"));
    }
}

