/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.impl.variant;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.animal.WolfVariants;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.walkers.api.variant.TypeProvider;

public class WolfTypeProvider
extends TypeProvider<Wolf> {
    private static int range = 9;

    public WolfTypeProvider() {
        if (PlatformData.getEnv() == Dist.CLIENT) {
            WolfTypeProvider.setClientRange();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void setClientRange() {
        ClientLevel clientLevel = Minecraft.getInstance().level;
        if (clientLevel != null) {
            WolfTypeProvider.setRange((Level)clientLevel);
        }
    }

    @Override
    public int getVariantData(Wolf entity) {
        WolfTypeProvider.setRange(entity.level());
        return entity.level().registryAccess().registryOrThrow(Registries.WOLF_VARIANT).getId((Object)((WolfVariant)entity.getVariant().value()));
    }

    @Override
    public Wolf create(EntityType<Wolf> type, Level level, int data) {
        WolfTypeProvider.setRange(level);
        Wolf wolf = (Wolf)type.create(level);
        if (wolf != null) {
            Registry wolfVariantRegistry = level.registryAccess().registryOrThrow(Registries.WOLF_VARIANT);
            wolf.setVariant((Holder)wolfVariantRegistry.getHolder(data).orElse(wolfVariantRegistry.getHolderOrThrow(WolfVariants.PALE)));
        }
        return wolf;
    }

    @Override
    public int getFallbackData() {
        return 0;
    }

    @Override
    public int getRange() {
        return range;
    }

    public static void setRange(Level level) {
        range = level.registryAccess().registryOrThrow(Registries.WOLF_VARIANT).size() - 1;
    }

    @Override
    public Component modifyText(Wolf entity, MutableComponent text) {
        WolfTypeProvider.setRange(entity.level());
        return TComponent.literal((String)(this.formatTypePrefix(Objects.requireNonNull(entity.level().registryAccess().registryOrThrow(Registries.WOLF_VARIANT).getKey((Object)((WolfVariant)entity.getVariant().value()))).getPath()) + " ")).append((Component)text);
    }
}

