/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.impl.tick.shapes;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.player.Player;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.api.WalkersTickHandler;

public class FrogTickHandler
implements WalkersTickHandler<Frog> {
    @Override
    public void tick(Player player, Frog frog) {
        if (CEntity.level((Entity)player).isClientSide) {
            boolean swim;
            boolean walk = CEntity.isOnGround((Entity)player) && player.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6 && !player.isInWaterOrBubble();
            boolean bl = swim = player.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6 && player.isInWaterOrBubble();
            if (!(CEntity.isOnGround((Entity)player) || swim || walk || player.isInWaterOrBubble())) {
                frog.jumpAnimationState.startIfStopped(frog.tickCount);
            } else {
                frog.jumpAnimationState.stop();
            }
            if (swim) {
                frog.swimIdleAnimationState.stop();
            } else if (player.isInWaterOrBubble()) {
                frog.swimIdleAnimationState.startIfStopped(frog.tickCount);
            } else {
                frog.swimIdleAnimationState.stop();
            }
            if (CEntity.level((Entity)player).random.nextDouble() <= 0.001) {
                frog.croakAnimationState.start(player.tickCount);
            }
            if (player.swinging) {
                frog.tongueAnimationState.startIfStopped(player.tickCount);
            } else {
                frog.tongueAnimationState.stop();
            }
        } else {
            player.addEffect(new MobEffectInstance(MobEffects.JUMP, 40, 2, true, false));
        }
    }
}

